/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;

public class RenderResizableQuadrilateral {
    public static final RenderResizableQuadrilateral INSTANCE = new RenderResizableQuadrilateral();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.y(), vector.z());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.x(), value, vector.z());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.x(), vector.y(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static double getValue(Vec3 vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.f_82479_;
        }
        if (axis == Direction.Axis.Y) {
            return vector.f_82480_;
        }
        if (axis == Direction.Axis.Z) {
            return vector.f_82481_;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public void renderSquare(BloodMagicRenderer.Model2D square, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay) {
        float red = BloodMagicRenderer.getRed(argb);
        float green = BloodMagicRenderer.getGreen(argb);
        float blue = BloodMagicRenderer.getBlue(argb);
        float alpha = BloodMagicRenderer.getAlpha(argb);
        Vec3 size = new Vec3(square.sizeX(), 0.0, square.sizeY());
        matrix.m_85836_();
        matrix.m_85837_(square.minX, 0.0, square.minY);
        PoseStack.Pose lastMatrix = matrix.m_85850_();
        Matrix4f matrix4f = lastMatrix.m_252922_();
        Matrix3f normal = lastMatrix.m_252943_();
        Direction face = Direction.UP;
        int ordinal = face.ordinal();
        ResourceLocation rl = square.resource;
        if (rl != null) {
            Direction.Axis u = face.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.m_122434_() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.m_122421_() == Direction.AxisDirection.POSITIVE ? (float)RenderResizableQuadrilateral.getValue(size, face.m_122434_()) : 0.0f;
            face = face.m_122421_() == Direction.AxisDirection.NEGATIVE ? face : face.m_122424_();
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 1.0f;
            float maxV = 0.0f;
            double sizeU = RenderResizableQuadrilateral.getValue(size, u);
            double sizeV = RenderResizableQuadrilateral.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.m_85849_();
    }

    private void renderPoint(Matrix4f matrix4f, Matrix3f normal, VertexConsumer buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light, int overlay) {
        int U_ARRAY = minU ? 0 : 1;
        int V_ARRAY = minV ? 2 : 3;
        Vector3f vertex = RenderResizableQuadrilateral.withValue(VEC_ZERO, u, xyz[U_ARRAY]);
        vertex = RenderResizableQuadrilateral.withValue(vertex, v, xyz[V_ARRAY]);
        vertex = RenderResizableQuadrilateral.withValue(vertex, face.m_122434_(), other);
        Vec3i normalForFace = face.m_122436_();
        float adjustment = 2.5f;
        Vector3f norm = new Vector3f((float)normalForFace.m_123341_() + adjustment, (float)normalForFace.m_123342_() + adjustment, (float)normalForFace.m_123343_() + adjustment);
        norm.normalize();
        buffer.m_252986_(matrix4f, vertex.x(), vertex.y(), vertex.z()).m_85950_(red, green, blue, alpha).m_7421_(uv[U_ARRAY], uv[V_ARRAY]).m_86008_(overlay).m_85969_(light).m_252939_(normal, norm.x(), norm.y(), norm.z()).m_5752_();
    }
}

