/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.routing.INodeRenderer;
import wayoftime.bloodmagic.common.tile.routing.TileRoutingNode;

public class RenderItemRoutingNode
implements BlockEntityRenderer<TileRoutingNode> {
    private static final ResourceLocation beamTexture = new ResourceLocation("bloodmagic", "textures/entities/nodebeam.png");
    private static final Minecraft mc = Minecraft.m_91087_();

    public RenderItemRoutingNode(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileRoutingNode tileNode, float partialTicks, PoseStack matrixStack, MultiBufferSource renderer, int combinedLightIn, int combinedOverlayIn) {
        if (RenderItemRoutingNode.mc.f_91074_.m_21205_().m_41720_() instanceof INodeRenderer || ((Boolean)ConfigManager.CLIENT.alwaysRenderRoutingLines.get()).booleanValue()) {
            List<BlockPos> connectionList = tileNode.getConnected();
            BlockPos masterPos = tileNode.getMasterPos();
            for (BlockPos wantedPos : connectionList) {
                boolean doRender;
                BlockPos offsetPos = wantedPos.m_121996_((Vec3i)tileNode.m_58899_());
                int xd = offsetPos.m_123341_();
                int yd = offsetPos.m_123342_();
                int zd = offsetPos.m_123343_();
                boolean bl = doRender = wantedPos.equals((Object)masterPos) || xd > 0 || xd == 0 && zd > 0 || zd == 0 && yd > 0;
                if (!doRender) continue;
                double distance = Math.sqrt(xd * xd + yd * yd + zd * zd);
                double subLength = Mth.m_14116_((float)(xd * xd + zd * zd));
                float rotYaw = -((float)(Math.atan2(xd, zd) * 180.0 / Math.PI));
                float rotPitch = (float)(Math.atan2(yd, subLength) * 180.0 / Math.PI);
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-rotYaw));
                matrixStack.m_252781_(Axis.f_252495_.m_252977_(rotPitch - 90.0f));
                matrixStack.m_85836_();
                long i = tileNode.m_58904_().m_46467_();
                boolean j = false;
                float[] colors = new float[]{0.0f, 1.0f, 1.0f};
                float height = (float)distance;
                RenderItemRoutingNode.renderBeamSegment(matrixStack, renderer, partialTicks, i, (float)j, height, colors);
                matrixStack.m_85849_();
                matrixStack.m_85849_();
            }
        }
    }

    private static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTicks, long totalWorldTime, float yOffset, float height, float[] colors) {
        RenderItemRoutingNode.renderBeamSegment(matrixStackIn, bufferIn, beamTexture, partialTicks, 1.0f, totalWorldTime, yOffset, height, colors, 0.06f, 0.1f);
    }

    public static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, ResourceLocation textureLocation, float partialTicks, float textureScale, long totalWorldTime, float yOffset, float height, float[] colors, float beamRadius, float glowRadius) {
        float i = yOffset + height;
        matrixStackIn.m_85836_();
        float f = (float)Math.floorMod(totalWorldTime, 40L) + partialTicks;
        float f1 = height < 0.0f ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float f3 = colors[0];
        float f4 = colors[1];
        float f5 = colors[2];
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -beamRadius;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = -beamRadius;
        float f13 = 0.0f;
        float f14 = 1.0f;
        float f15 = -1.0f + f2;
        float f16 = height * textureScale * (0.5f / beamRadius) + f15;
        RenderItemRoutingNode.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (boolean)false)), f3, f4, f5, 1.0f, yOffset, i, 0.0f, beamRadius, beamRadius, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        matrixStackIn.m_85849_();
        f6 = -glowRadius;
        float f7 = -glowRadius;
        f8 = -glowRadius;
        f9 = -glowRadius;
        f13 = 0.0f;
        f14 = 1.0f;
        f15 = -1.0f + f2;
        f16 = height * textureScale + f15;
        RenderItemRoutingNode.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (boolean)true)), f3, f4, f5, 0.125f, yOffset, i, f6, f7, glowRadius, f8, f9, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.m_85849_();
    }

    private static void renderPart(PoseStack matrixStackIn, VertexConsumer bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float p_228840_8_, float p_228840_9_, float p_228840_10_, float p_228840_11_, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float u1, float u2, float v1, float v2) {
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_8_, p_228840_9_, p_228840_10_, p_228840_11_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_10_, p_228840_11_, p_228840_14_, p_228840_15_, u1, u2, v1, v2);
        RenderItemRoutingNode.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_12_, p_228840_13_, p_228840_8_, p_228840_9_, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        RenderItemRoutingNode.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, float y, float x, float z, float texU, float texV) {
        bufferIn.m_252986_(matrixPos, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(TileRoutingNode te) {
        return true;
    }
}

