/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.api;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import wayoftime.bloodmagic.api.IBloodMagicBlacklist;
import wayoftime.bloodmagic.api.IBloodMagicValueManager;

public interface IBloodMagicAPI {
    public static final LazyLoadedValue<IBloodMagicAPI> INSTANCE = new LazyLoadedValue(() -> {
        try {
            return (IBloodMagicAPI)Class.forName("wayoftime.bloodmagic.impl.BloodMagicAPI").getDeclaredField("INSTANCE").get(null);
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find BloodMagicAPI, using a dummy instance instead...");
            return new IBloodMagicAPI(){};
        }
    });

    @Nonnull
    default public IBloodMagicBlacklist getBlacklist() {
        return new IBloodMagicBlacklist(){};
    }

    @Nonnull
    default public IBloodMagicValueManager getValueManager() {
        return new IBloodMagicValueManager(){};
    }

    default public void registerAltarComponent(@Nonnull BlockState state, @Nonnull String componentType) {
    }

    default public void unregisterAltarComponent(@Nonnull BlockState state, @Nonnull String componentType) {
    }

    default public void registerTranquilityHandler(Predicate<BlockState> predicate, String tranquilityType, double value) {
    }

    default public void registerInventoryProvider(String inventoryIdentifier, Function<Player, NonNullList<ItemStack>> provider) {
    }

    default public void registerActiveInventoryProvider(String inventoryIdentifier) {
    }

    default public double getTotalDemonWill(String willType, Player player) {
        return 0.0;
    }
}

