/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.anointment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.living.LivingUpgrade;

@JsonAdapter(value=Deserializer.class)
public class Anointment {
    public static final Anointment DUMMY = new Anointment(new ResourceLocation("dummy"));
    private final ResourceLocation key;
    private final Set<ResourceLocation> incompatible;
    private String translationKey = null;
    private final Map<String, Bonus> bonuses;
    private IAttributeProvider attributeProvider;
    private IDamageProvider damageProvider;
    private boolean consumeOnAttack = false;
    private boolean consumeOnUseFinish = false;
    private boolean consumeOnHarvest = false;

    public Anointment(ResourceLocation key) {
        this.key = key;
        this.incompatible = Sets.newHashSet();
        this.bonuses = Maps.newHashMap();
    }

    public Anointment withBonusSet(String id, Consumer<List<Number>> modifiers) {
        ArrayList<Number> values2 = new ArrayList<Number>();
        modifiers.accept(values2);
        this.bonuses.put(id, new Bonus(id, values2));
        return this;
    }

    public Number getBonusValue(String id, int level) {
        List<Number> modifiers = this.bonuses.getOrDefault((Object)id, (Bonus)Bonus.DEFAULT).modifiers;
        if (modifiers.isEmpty() || level == 0) {
            return 0;
        }
        return level <= modifiers.size() ? (Number)modifiers.get(level - 1) : (Number)modifiers.get(modifiers.size() - 1);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean applyAnointment(AnointmentHolder holder, ItemStack stack, int level) {
        if (level < 0) {
            return false;
        }
        IAttributeProvider prov = this.getAttributeProvider();
        if (prov == null) {
            return true;
        }
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(stack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
        this.getAttributeProvider().handleAttributes(holder, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(this.getKey().toString().getBytes()), this, level);
        for (Map.Entry entry : modifiers.entries()) {
            stack.m_41643_((Attribute)entry.getKey(), (AttributeModifier)entry.getValue(), EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean removeAnointment(AnointmentHolder holder, ItemStack stack, EquipmentSlot slot) {
        IAttributeProvider provider = this.getAttributeProvider();
        if (provider != null) {
            HashMultimap modifiers = HashMultimap.create();
            this.getAttributeProvider().handleAttributes(holder, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(this.getKey().toString().getBytes()), this, 1);
            if (stack.m_41782_() && stack.m_41783_().m_128425_("AttributeModifiers", 9)) {
                ListTag listnbt = stack.m_41783_().m_128437_("AttributeModifiers", 10);
                ArrayList<Integer> removeList = new ArrayList<Integer>();
                for (int i = 0; i < listnbt.size(); ++i) {
                    AttributeModifier attributemodifier;
                    Optional<Attribute> optional;
                    CompoundTag compoundnbt = listnbt.m_128728_(i);
                    if (compoundnbt.m_128425_("Slot", 8) && !compoundnbt.m_128461_("Slot").equals(slot.m_20751_()) || !(optional = Optional.ofNullable((Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)compoundnbt.m_128461_("AttributeName"))))).isPresent() || (attributemodifier = AttributeModifier.m_22212_((CompoundTag)compoundnbt)) == null || attributemodifier.m_22209_().getLeastSignificantBits() == 0L || attributemodifier.m_22209_().getMostSignificantBits() == 0L) continue;
                    for (Map.Entry entry : modifiers.entries()) {
                        if (!((Attribute)entry.getKey()).equals(optional.get()) || !((AttributeModifier)entry.getValue()).m_22209_().equals(attributemodifier.m_22209_())) continue;
                        removeList.add(i);
                    }
                }
                Iterator iterator = removeList.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    listnbt.remove(index);
                }
                if (removeList.size() >= 1) {
                    stack.m_41783_().m_128365_("AttributeModifiers", (Tag)listnbt);
                    if (listnbt.isEmpty()) {
                        stack.m_41783_().m_128473_("AttributeModifiers");
                    }
                }
            }
        }
        return false;
    }

    public boolean isCompatible(ResourceLocation otherUpgrade) {
        return !this.incompatible.contains(otherUpgrade);
    }

    public Anointment addIncompatibility(ResourceLocation key, ResourceLocation ... otherKeys) {
        this.incompatible.add(key);
        Collections.addAll(this.incompatible, otherKeys);
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey == null ? (this.translationKey = Util.m_137492_((String)"anointment", (ResourceLocation)this.key)) : this.translationKey;
    }

    public Anointment setConsumeOnAttack() {
        this.consumeOnAttack = true;
        return this;
    }

    public boolean consumeOnAttack() {
        return this.consumeOnAttack;
    }

    public Anointment setConsumeOnUseFinish() {
        this.consumeOnUseFinish = true;
        return this;
    }

    public boolean consumeOnUseFinish() {
        return this.consumeOnUseFinish;
    }

    public Anointment setConsumeOnHarvest() {
        this.consumeOnHarvest = true;
        return this;
    }

    public boolean consumeOnHarvest() {
        return this.consumeOnHarvest;
    }

    public Anointment withAttributeProvider(IAttributeProvider attributeProvider) {
        this.attributeProvider = attributeProvider;
        return this;
    }

    public IAttributeProvider getAttributeProvider() {
        return this.attributeProvider;
    }

    public Anointment withDamageProvider(IDamageProvider damageProvider) {
        this.damageProvider = damageProvider;
        return this;
    }

    public IDamageProvider getDamageProvider() {
        return this.damageProvider;
    }

    public static class Bonus {
        private static final Bonus DEFAULT = new Bonus("null", Collections.emptyList());
        private final String id;
        private final List<Number> modifiers;

        public Bonus(String id, List<Number> modifiers) {
            this.id = id;
            this.modifiers = modifiers;
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface IAttributeProvider {
        public void handleAttributes(AnointmentHolder var1, Multimap<Attribute, AttributeModifier> var2, UUID var3, Anointment var4, int var5);
    }

    public static interface IDamageProvider {
        public double getAdditionalDamage(Player var1, ItemStack var2, double var3, AnointmentHolder var5, LivingEntity var6, Anointment var7, int var8);
    }

    public static class Deserializer
    implements JsonDeserializer<Anointment> {
        public Anointment deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(json.getAsJsonPrimitive("id").getAsString());
            List levels = (List)context.deserialize((JsonElement)json.getAsJsonArray("levels"), new TypeToken<List<LivingUpgrade.Level>>(){}.getType());
            boolean negative = json.has("negative") && json.getAsJsonPrimitive("negative").getAsBoolean();
            Anointment upgrade = new Anointment(id);
            if (json.has("bonuses")) {
                Map bonuses = (Map)context.deserialize((JsonElement)json.getAsJsonObject("bonuses"), new TypeToken<Map<String, Number[]>>(){}.getType());
                bonuses.forEach((k, v) -> upgrade.withBonusSet((String)k, numbers -> Collections.addAll(numbers, v)));
            }
            return upgrade;
        }
    }
}

