/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import dev.latvian.mods.itemfilters.api.FilterInfo;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.core.ItemFiltersStack;
import dev.latvian.mods.itemfilters.gui.InventoryFilterMenu;
import dev.latvian.mods.itemfilters.item.BaseFilterItem;
import dev.latvian.mods.itemfilters.item.ItemInventory;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class InventoryFilterItem
extends BaseFilterItem {
    public static ItemInventory getInventory(ItemStack stack) {
        return ((ItemFiltersStack)stack).getInventoryFilterData();
    }

    public int getInventorySize(ItemStack filter) {
        return 27;
    }

    public void addSlots(ItemStack filter, List<FilterSlot> list) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                list.add(new FilterSlot(8 + j * 18, 16 + i * 18));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, final InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_()) {
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf buf) {
                    buf.writeBoolean(hand == InteractionHand.MAIN_HAND);
                }

                public Component m_5446_() {
                    return stack.m_41611_();
                }

                public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                    return new InventoryFilterMenu(i, inventory, hand);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void clearFilterCache(ItemStack filter) {
        super.clearFilterCache(filter);
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        for (ItemStack item : inventory.getItems()) {
            IItemFilter f = ItemFiltersAPI.getFilter(item);
            if (f == null) continue;
            f.clearFilterCache(item);
        }
    }

    @Override
    public void resetFilterData(ItemStack filter) {
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        inventory.m_6211_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemStack filter, FilterInfo info, boolean expanded) {
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        if (inventory == null) {
            return;
        }
        for (ItemStack stack1 : inventory.getItems()) {
            IItemFilter filter1;
            info.add(stack1.m_41786_());
            if (!expanded || (filter1 = ItemFiltersAPI.getFilter(stack1)) == null) continue;
            info.push();
            filter1.addInfo(stack1, info, true);
            info.pop();
        }
    }

    public static class FilterSlot {
        public final int x;
        public final int y;

        public FilterSlot(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }
    }
}

