/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.recipes.transform.TransformRecipe;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public final class LavaTransformLogic {
    private static final Set<Item> lavaCache = new HashSet<Item>();

    public static boolean canTransformInLava(ItemEntity entity) {
        return LavaTransformLogic.getLavaTransformableItems(entity.m_9236_()).contains(entity.m_32055_().m_41720_());
    }

    public static boolean allIngredientsPresent(ItemEntity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        Level level = entity.m_9236_();
        List<Item> items = level.m_45933_(null, new AABB(x - 1.0, y - 1.0, z - 1.0, x + 1.0, y + 1.0, z + 1.0)).stream().filter(e -> e instanceof ItemEntity && !e.m_213877_()).map(e -> ((ItemEntity)e).m_32055_().m_41720_()).toList();
        for (TransformRecipe recipe : level.m_7465_().m_44013_(TransformRecipe.TYPE)) {
            if (!recipe.circumstance.isFluidTag(FluidTags.f_13132_)) continue;
            return recipe.m_7527_().stream().noneMatch(ingredient -> {
                for (ItemStack stack : ingredient.m_43908_()) {
                    if (!items.contains(stack.m_41720_())) continue;
                    return false;
                }
                return true;
            });
        }
        return false;
    }

    private static Set<Item> getLavaTransformableItems(Level level) {
        if (lavaCache.isEmpty()) {
            for (TransformRecipe recipe : level.m_7465_().m_44013_(TransformRecipe.TYPE)) {
                if (!recipe.circumstance.isFluidTag(FluidTags.f_13132_)) continue;
                for (Ingredient ingredient : recipe.ingredients) {
                    for (ItemStack stack : ingredient.m_43908_()) {
                        lavaCache.add(stack.m_41720_());
                    }
                }
            }
        }
        return lavaCache;
    }

    public static void clearCache() {
        lavaCache.clear();
    }
}

