/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.block;

import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerPatchBlock
extends FlowerBlock
implements BonemealableBlock,
PatchBlock {
    public static final int MAX_FLOWERS = 4;
    public static final IntegerProperty FLOWERS = IntegerProperty.m_61631_((String)"flowers", (int)2, (int)4);
    protected static final VoxelShape ONE_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    protected static final VoxelShape TWO_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape THREE_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape FOUR_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private final Supplier<Block> flowerDelegate;

    public FlowerPatchBlock(MobEffect mobEffect, int effectsDuration, Supplier<Block> flowerSupplier, BlockBehaviour.Properties properties) {
        super(mobEffect, effectsDuration, properties);
        this.flowerDelegate = flowerSupplier;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FLOWERS, (Comparable)Integer.valueOf(2)));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext placeContext) {
        return super.m_6864_(state, placeContext) && placeContext.m_43722_().m_41720_() == this.flowerDelegate.get().m_5456_();
    }

    @Override
    public Supplier<Block> getPatchDelegate() {
        return this.flowerDelegate;
    }

    @Override
    public IntegerProperty getProperty() {
        return FLOWERS;
    }

    @Override
    public int getMaxAmount() {
        return 4;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Vec3 vec3 = state.m_60824_(blockGetter, pos);
        switch ((Integer)state.m_61143_((Property)FLOWERS)) {
            default: {
                return ONE_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            case 2: {
                return TWO_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            case 3: {
                return THREE_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            case 4: 
        }
        return FOUR_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FLOWERS});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.flowerDelegate.get());
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos pos, BlockState state, boolean isClient) {
        return Services.PLATFORM.patchBonemealing() && (Integer)state.m_61143_((Property)FLOWERS) < 4;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FLOWERS, (Comparable)Integer.valueOf(Mth.m_14045_((int)((Integer)state.m_61143_((Property)FLOWERS) + 1), (int)2, (int)4))), 3);
    }
}

