/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch;

import com.mrbysco.flowerpatch.CommonClass;
import com.mrbysco.flowerpatch.client.ClientHandler;
import com.mrbysco.flowerpatch.config.PatchConfigForge;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="flowerpatch")
public class FlowerPatchForge {
    public FlowerPatchForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PatchConfigForge.commonSpec);
        CommonClass.init();
        MinecraftForge.EVENT_BUS.addListener(this::onBlockInteraction);
        MinecraftForge.EVENT_BUS.addListener(this::onBonemeal);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> eventBus.addListener(ClientHandler::onClientSetup));
    }

    private void onBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        BlockPos pos;
        Level level = event.getLevel();
        InteractionResult result = CommonClass.onBlockInteraction(level, pos = event.getPos(), player = event.getEntity(), event.getHand());
        if (result == InteractionResult.FAIL) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    private void onBonemeal(BonemealEvent event) {
        Player player;
        ItemStack stack;
        BlockState state;
        BlockPos pos;
        Level level = event.getLevel();
        InteractionResult result = CommonClass.onBonemeal(level, pos = event.getPos(), state = event.getBlock(), stack = event.getStack(), player = event.getEntity());
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }
}

