/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.data;

import edivad.extrastorage.ExtraStorage;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ExtraStorageTags {

    public static class Items {
        public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final TagKey<Item> ITEM_STORAGE_BLOCKS = Items.tag("storage_blocks/items");
        public static final TagKey<Item> FLUID_STORAGE_BLOCKS = Items.tag("storage_blocks/fluids");
        public static final Map<ItemStorageType, TagKey<Item>> STORAGE_BLOCKS_ITEM = new HashMap<ItemStorageType, TagKey<Item>>();
        public static final Map<FluidStorageType, TagKey<Item>> STORAGE_BLOCKS_FLUID = new HashMap<FluidStorageType, TagKey<Item>>();
        public static final TagKey<Item> PARTS = Items.tag("parts");
        public static final TagKey<Item> ITEM_PARTS = Items.tag("parts/items");
        public static final TagKey<Item> FLUID_PARTS = Items.tag("parts/fluids");
        public static final Map<ItemStorageType, TagKey<Item>> PARTS_ITEM = new HashMap<ItemStorageType, TagKey<Item>>();
        public static final Map<FluidStorageType, TagKey<Item>> PARTS_FLUID = new HashMap<FluidStorageType, TagKey<Item>>();
        public static final TagKey<Item> DISKS = Items.tag("disks");
        public static final TagKey<Item> ITEM_DISKS = Items.tag("disks/items");
        public static final TagKey<Item> FLUID_DISKS = Items.tag("disks/fluids");
        public static final Map<ItemStorageType, TagKey<Item>> DISKS_ITEM = new HashMap<ItemStorageType, TagKey<Item>>();
        public static final Map<FluidStorageType, TagKey<Item>> DISKS_FLUID = new HashMap<FluidStorageType, TagKey<Item>>();

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("refinedstorage", name));
        }

        static {
            for (ItemStorageType itemStorageType : ItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(itemStorageType, Items.tag("storage_blocks/items/" + itemStorageType.getName()));
                PARTS_ITEM.put(itemStorageType, Items.tag("parts/items/" + itemStorageType.getName()));
                DISKS_ITEM.put(itemStorageType, Items.tag("disks/items/" + itemStorageType.getName()));
            }
            for (Enum enum_ : FluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((FluidStorageType)enum_, Items.tag("storage_blocks/fluids/" + ((FluidStorageType)enum_).getName()));
                PARTS_FLUID.put((FluidStorageType)enum_, Items.tag("parts/fluids/" + ((FluidStorageType)enum_).getName()));
                DISKS_FLUID.put((FluidStorageType)enum_, Items.tag("disks/fluids/" + ((FluidStorageType)enum_).getName()));
            }
        }
    }

    public static class Blocks {
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.RSTag("storage_blocks");
        public static final TagKey<Block> CRAFTER = Blocks.tag("crafter");
        public static final TagKey<Block> ITEM_STORAGE_BLOCKS = Blocks.RSTag("storage_blocks/items");
        public static final TagKey<Block> FLUID_STORAGE_BLOCKS = Blocks.RSTag("storage_blocks/fluids");
        public static final Map<ItemStorageType, TagKey<Block>> STORAGE_BLOCKS_ITEM = new HashMap<ItemStorageType, TagKey<Block>>();
        public static final Map<FluidStorageType, TagKey<Block>> STORAGE_BLOCKS_FLUID = new HashMap<FluidStorageType, TagKey<Block>>();
        public static final TagKey<Block> CARRY_ON_BLACKLIST;
        public static final TagKey<Block> MEKANISM_BLACKLIST;
        public static final TagKey<Block> RELOCATION_NOT_SUPPORTED;

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)ExtraStorage.rl(name));
        }

        private static TagKey<Block> RSTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("refinedstorage", name));
        }

        private static TagKey<Block> carryOnTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("carryon", name));
        }

        private static TagKey<Block> forgeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        private static TagKey<Block> mekanismTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("mekanism", name));
        }

        private static TagKey<Block> packingTapeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("packingtape", name));
        }

        static {
            for (ItemStorageType itemStorageType : ItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(itemStorageType, Blocks.RSTag("storage_blocks/items/" + itemStorageType.getName()));
            }
            for (Enum enum_ : FluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((FluidStorageType)enum_, Blocks.RSTag("storage_blocks/fluids/" + ((FluidStorageType)enum_).getName()));
            }
            CARRY_ON_BLACKLIST = Blocks.carryOnTag("block_blacklist");
            MEKANISM_BLACKLIST = Blocks.mekanismTag("cardboard_blacklist");
            RELOCATION_NOT_SUPPORTED = Blocks.forgeTag("relocation_not_supported");
        }
    }
}

