/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.render.tile;

import com.breakinblocks.plonk.client.util.RenderUtils;
import com.breakinblocks.plonk.common.block.BlockPlacedItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.MatrixUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class TESRPlacedItems
implements BlockEntityRenderer<TilePlacedItems> {
    public static final DirectionProperty FACING = BlockPlacedItems.FACING;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final ItemRenderer itemRenderer = mc.m_91291_();
    private static final double EPS = 0.001;

    public TESRPlacedItems(BlockEntityRendererProvider.Context context) {
    }

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        BakedModel model = itemRenderer.m_174264_(itemstack, null, null, 0);
        Matrix4f matrixFixed = RenderUtils.getModelTransformMatrix(model, ItemDisplayContext.FIXED);
        Matrix4f matrixGui = RenderUtils.getModelTransformMatrix(model, ItemDisplayContext.GUI);
        Matrix4f difference = MatrixUtils.difference(matrixFixed, matrixGui);
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(difference);
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        double blockRot = 75.0;
        if (74.999 <= hRot && hRot <= 75.001) {
            return 1;
        }
        return 0;
    }

    public void render(TilePlacedItems tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        Direction facing = Direction.UP;
        if (tileEntityIn.m_58898_() && (blockstate = tileEntityIn.m_58900_()).m_60734_() instanceof BlockPlacedItems) {
            facing = (Direction)blockstate.m_61143_((Property)FACING);
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
        }
        matrixStackIn.m_85837_(0.0, -0.5, 0.0);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)(-tileEntityIn.getTileRotationAngle())));
        ItemStack[] contents = tileEntityIn.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = tileEntityIn.getContentsMeta();
        int num = contents.length;
        Level level = tileEntityIn.m_58904_();
        int seed = (int)tileEntityIn.m_58899_().m_121878_();
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = tileEntityIn.m_8020_(slot);
                if (stack.m_41619_()) continue;
                matrixStackIn.m_85836_();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            matrixStackIn.m_85837_(-0.25, 0.0, 0.0);
                            break;
                        }
                        matrixStackIn.m_85837_(0.25, 0.0, 0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        matrixStackIn.m_85837_(left ? -0.25 : 0.25, 0.0, top ? -0.25 : 0.25);
                    }
                }
                this.renderStack(partialTicks, matrixStackIn, bufferIn, combinedLightIn, level, seed + slot, stack, contentsMeta[slot], halfSize);
                matrixStackIn.m_85849_();
            }
        }
        matrixStackIn.m_85849_();
    }

    public void renderStack(float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, @Nullable Level level, int seed, ItemStack stack, TilePlacedItems.ItemMeta meta, boolean halfSize) {
        if (stack.m_41619_()) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)(-meta.getRotationAngle())));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        switch (meta.renderType) {
            case 1: {
                matrixStackIn.m_252880_(0.0f, 0.25f, 0.0f);
                itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, seed);
                break;
            }
            default: {
                matrixStackIn.m_252880_(0.0f, 0.041666668f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                if (halfSize) {
                    matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                }
                itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, seed);
            }
        }
        matrixStackIn.m_85849_();
    }
}

