/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.blocks.machines.FusionCraftingCore;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import java.util.Locale;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FusionRecipeCategory
implements IRecipeCategory<IFusionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final int xSize = 164;
    private final int ySize = 111;

    public FusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("draconicevolution", "textures/gui/jei_fusion_background.png"), 0, 0, 164, 111);
        this.localizedName = Component.m_237115_((String)((FusionCraftingCore)((Object)DEContent.CRAFTING_CORE.get())).m_7705_());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)DEContent.CRAFTING_CORE.get()));
    }

    @Nonnull
    public RecipeType<IFusionRecipe> getRecipeType() {
        return DEJEIPlugin.FUSION_RECIPE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IFusionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        GuiRender render = GuiRender.convert((GuiGraphics)graphics);
        TechLevel tier = recipe.getRecipeTier();
        int colour = tier.index == 0 ? 0x5050FF : (tier.index == 1 ? 0x8000FF : (tier.index == 2 ? 0xFF6600 : 0x505050));
        render.drawCenteredString(I18n.m_118938_((String)("gui.draconicevolution.fusion_craft.tier." + recipe.getRecipeTier().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]), (double)this.xSize / 2.0, 5.0, colour, false);
        render.drawCenteredString(I18n.m_118938_((String)"gui.draconicevolution.fusion_craft.energy_cost", (Object[])new Object[0]), (double)this.xSize / 2.0, (double)(this.ySize - 20), 0x4444FF, false);
        render.drawCenteredString(Utils.addCommas((long)recipe.getEnergyCost()) + " OP", (double)this.xSize / 2.0, (double)(this.ySize - 10), 0x44AAFF, false);
        render.borderRect(72.0, 22.0, 20.0, 66.0, 1.0, 0x40FFFFFF, -16711681);
        if (recipe.m_7527_().size() > 16) {
            render.borderRect(3.0, 2.0, 18.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
            render.borderRect(23.0, 2.0, 18.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
            render.borderRect(143.0, 2.0, 18.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
            render.borderRect(123.0, 2.0, 18.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
        } else {
            render.borderRect(12.0, 2.0, 20.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
            render.borderRect(132.0, 2.0, 20.0, 107.0, 1.0, 0x40FFFFFF, -5635841);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, IFusionRecipe recipe, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 74, 24).addIngredients(recipe.getCatalyst())).setSlotName("catalyst");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 70).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()))).setSlotName("output");
        NonNullList<Ingredient> ingreds = recipe.m_7527_();
        int nColumns = ingreds.size() > 16 ? 4 : 2;
        int xc = 74;
        int yc = 55;
        int rows = (int)Math.ceil((double)ingreds.size() / (double)nColumns);
        for (int i = 0; i < ingreds.size(); ++i) {
            int side;
            int n = side = i % nColumns >= nColumns / 2 ? 1 : -1;
            int offset = nColumns == 2 ? 0 : (i % 2 == 0 ? -1 : 1);
            int row = i / nColumns;
            int xPos = xc + side * (60 + offset * 10);
            int yPos = yc;
            if (rows > 1) {
                yPos = yc - 42 + 84 / (rows - 1) * row;
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xPos, yPos - 8).addIngredients((Ingredient)ingreds.get(i))).setSlotName("input_" + i);
        }
    }
}

