/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.handlers.DESounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class ReactorSound
extends SimpleSoundInstance
implements TickableSoundInstance {
    public boolean donePlaying = false;
    private TileReactorCore tile;
    private float targetPitch;
    private float targetVolume;
    private int stopTimer = 0;

    public ReactorSound(TileReactorCore tile) {
        super((SoundEvent)DESounds.CORE_SOUND.get(), SoundSource.BLOCKS, tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE ? 10.0f : 1.5f, 1.0f, tile.m_58904_().f_46441_, tile.m_58899_());
        this.tile = tile;
        this.f_119578_ = true;
        this.targetPitch = 1.0f;
    }

    public boolean m_7801_() {
        return this.donePlaying;
    }

    public void m_7788_() {
        block13: {
            block12: {
                if (this.tile.roller != null) {
                    this.f_119575_ = (float)this.tile.roller.pos.x;
                    this.f_119576_ = (float)this.tile.roller.pos.y;
                    this.f_119577_ = (float)this.tile.roller.pos.z;
                } else {
                    this.f_119575_ = (float)this.tile.m_58899_().m_123341_() + 0.5f;
                    this.f_119576_ = (float)this.tile.m_58899_().m_123342_() + 0.5f;
                    this.f_119577_ = (float)this.tile.m_58899_().m_123343_() + 0.5f;
                }
                this.f_119574_ = (float)MathHelper.approachExp((double)this.f_119574_, (double)this.targetPitch, (double)0.05);
                if (this.tile.reactorState.get() == TileReactorCore.ReactorState.WARMING_UP || this.tile.reactorState.get() == TileReactorCore.ReactorState.STOPPING || this.tile.reactorState.get() == TileReactorCore.ReactorState.COOLING) {
                    this.targetPitch = 0.5f + this.tile.shieldAnimationState / 2.0f;
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.RUNNING) {
                    this.targetPitch = 1.0f + (float)Math.max(0.0, Math.min(0.5, 1.0 - this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get() * 10.0));
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                    if (this.f_119573_ == 1.5f) {
                        this.donePlaying = true;
                    }
                    if (this.tile.m_58904_().f_46441_.m_188503_(10) == 0) {
                        this.targetPitch = 1.0f + this.tile.m_58904_().f_46441_.m_188501_() / 2.0f;
                    }
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (this.tile.m_58901_() || player == null) break block12;
                double d = player.m_20238_(Vec3.m_82528_((Vec3i)this.tile.m_58899_()));
                int n = this.f_119573_ > 1.5f ? 4096 : 512;
                if (!(d > (double)n)) break block13;
            }
            this.donePlaying = true;
            this.f_119578_ = false;
        }
    }
}

