/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GuardianChargeParticle
extends SingleQuadParticle {
    private Vector3 startPos;
    private Vector3 endPos;
    private double angularPos;
    private PhaseManager phaseManager;
    public TextureAtlasSprite sprite = AtlasTextureHelper.ORB_PARTICLE;

    public GuardianChargeParticle(ClientLevel world, Vector3 startPos, Vector3 endPos, double angularPos, int life, PhaseManager phaseManager) {
        super(world, startPos.x, startPos.y, startPos.z);
        this.startPos = startPos;
        this.endPos = endPos;
        this.angularPos = angularPos;
        this.phaseManager = phaseManager;
        this.f_107225_ = life * 4;
        this.m_107253_(0.75f, 0.0f, 0.0f);
        this.m_6569_(5.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!(this.phaseManager.getCurrentPhase() instanceof ChargeUpPhase)) {
            this.f_107230_ = (float)((double)this.f_107230_ - 0.1);
        }
        if (this.f_107224_++ >= this.f_107225_ || this.f_107230_ <= 0.0f) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Quaternionf quaternion;
        if ((float)this.f_107224_ + partialTicks > (float)this.f_107225_) {
            return;
        }
        Vec3 vector3d = camera.m_90583_();
        float anim = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        Vector3 pos = MathUtils.interpolateVec3((Vector3)this.startPos, (Vector3)this.endPos, (double)anim);
        float radius = anim * 2.0f + Mth.m_14031_((float)(anim * (float)Math.PI)) * 5.0f;
        float x = (float)(pos.x - vector3d.m_7096_()) + Mth.m_14031_((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        float y = (float)(pos.y - vector3d.m_7098_());
        float z = (float)(pos.z - vector3d.m_7094_()) + Mth.m_14089_((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(x, y, z);
        }
        float uMin = this.m_5970_();
        float uMax = this.m_5952_();
        float vMin = this.m_5951_();
        float vMax = this.m_5950_();
        int j = 240;
        buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(uMax, vMax).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(uMax, vMin).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(uMin, vMin).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(uMin, vMax).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return AtlasTextureHelper.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected float m_5970_() {
        return this.sprite.m_118409_();
    }

    protected float m_5952_() {
        return this.sprite.m_118410_();
    }

    protected float m_5951_() {
        return this.sprite.m_118411_();
    }

    protected float m_5950_() {
        return this.sprite.m_118412_();
    }
}

