/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.items.equipment.ModularStaff;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.mojang.blaze3d.vertex.PoseStack;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;

public class ModularItemRenderOverrideHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(ModularItemRenderOverrideHandler::renderHandEvent);
    }

    private static void renderHandEvent(RenderHandEvent event) {
        LazyOptional opt;
        ItemStack usingItem;
        boolean renderingMainHand;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        InteractionHand hand = event.getHand();
        boolean bl = renderingMainHand = hand == InteractionHand.MAIN_HAND;
        if (renderingMainHand && player.m_6117_() && player.m_7655_() != hand && player.m_21212_() > 0 && (usingItem = player.m_21211_()).m_41720_() instanceof IModularItem && (opt = usingItem.getCapability(DECapabilities.MODULE_HOST_CAPABILITY)).isPresent()) {
            ModuleHost host = (ModuleHost)opt.orElseThrow(WTFException::new);
            for (ModuleEntity<?> entity : host.getModuleEntities()) {
                EntityOverridesItemUse override;
                if (!(entity instanceof EntityOverridesItemUse) || !(override = (EntityOverridesItemUse)((Object)entity)).overrideUsingPose(usingItem)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && stack.m_41720_() instanceof ModularStaff) {
            ModularItemRenderOverrideHandler.modularItemRenderOverride(stack, event);
            if (event.isCanceled()) {
                return;
            }
            HumanoidArm handside = mc.f_91074_.m_5737_();
            boolean rightHand = handside == HumanoidArm.RIGHT;
            float swingProgress = event.getSwingProgress();
            float equippedProgress = 0.0f;
            PoseStack mStack = event.getPoseStack();
            mStack.m_85836_();
            float f5 = -0.3f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float f6 = 0.05f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * ((float)Math.PI * 2)));
            float f10 = -0.3f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            int l = rightHand ? 1 : -1;
            mStack.m_252880_((float)l * f5, f6, f10);
            event.setCanceled(true);
            ModularItemRenderOverrideHandler.applyItemArmTransform(mStack, handside, equippedProgress);
            mc.f_91063_.f_109055_.m_269530_((LivingEntity)mc.f_91074_, stack, rightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !rightHand, mStack, event.getMultiBufferSource(), event.getPackedLight());
            mStack.m_85849_();
        } else if (stack.m_41720_() instanceof IModularItem) {
            ModularItemRenderOverrideHandler.modularItemRenderOverride(stack, event);
        }
    }

    private static void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equippedProg) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_((float)i * 0.56f, -0.52f + equippedProg * -0.6f, -0.72f);
    }

    private static void modularItemRenderOverride(ItemStack stack, RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_150108_() || !player.m_6117_() || player.m_21212_() <= 0 || player.m_7655_() != event.getHand()) {
            return;
        }
        stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).ifPresent(host -> {
            for (ModuleEntity<?> entity : host.getModuleEntities()) {
                if (!(entity instanceof EntityOverridesItemUse)) continue;
                EntityOverridesItemUse override = (EntityOverridesItemUse)((Object)entity);
                if (!override.overrideUsingPose(stack)) {
                    return;
                }
                event.setCanceled(true);
                ItemInHandRenderer renderer = mc.f_91063_.f_109055_;
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    ModularItemRenderOverrideHandler.renderArmWithItem(event, override, renderer, (AbstractClientPlayer)mc.f_91074_, InteractionHand.MAIN_HAND, event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                    continue;
                }
                ModularItemRenderOverrideHandler.renderArmWithItem(event, override, renderer, (AbstractClientPlayer)mc.f_91074_, InteractionHand.OFF_HAND, event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            }
        });
    }

    private static void renderArmWithItem(RenderHandEvent event, EntityOverridesItemUse override, ItemInHandRenderer renderer, AbstractClientPlayer clientPlayer, InteractionHand hand, ItemStack stack, float handHeight, PoseStack poseStack, MultiBufferSource getter, int packedLight) {
        boolean renderingMainHand = hand == InteractionHand.MAIN_HAND;
        HumanoidArm renderingArm = renderingMainHand ? clientPlayer.m_5737_() : clientPlayer.m_5737_().m_20828_();
        boolean rightHanded = renderingArm == HumanoidArm.RIGHT;
        poseStack.m_85836_();
        ModularItemRenderOverrideHandler.applyItemArmTransform(poseStack, renderingArm, handHeight);
        override.modifyFirstPersonUsingPose(event, !rightHanded);
        renderer.m_269530_((LivingEntity)clientPlayer, stack, rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !rightHanded, poseStack, getter, packedLight);
        poseStack.m_85849_();
    }

    public static void modifyPlayerPose(LivingEntity livingEntity, PlayerModel<?> model) {
        Player player;
        ItemStack stack;
        block3: {
            block2: {
                stack = livingEntity.m_21211_();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (livingEntity.m_6117_() && !stack.m_41619_() && livingEntity.m_21212_() > 0 && stack.m_41720_() instanceof IModularItem) break block3;
            }
            return;
        }
        boolean mainHand = player.m_7655_() == InteractionHand.MAIN_HAND;
        HumanoidArm arm = mainHand ? player.m_5737_() : player.m_5737_().m_20828_();
        boolean leftHand = arm == HumanoidArm.LEFT;
        stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).ifPresent(host -> {
            for (ModuleEntity<?> entity : host.getModuleEntities()) {
                if (!(entity instanceof EntityOverridesItemUse)) continue;
                EntityOverridesItemUse override = (EntityOverridesItemUse)((Object)entity);
                if (!override.overrideUsingPose(stack)) {
                    return;
                }
                override.modifyPlayerModelPose(player, model, leftHand);
            }
        });
    }
}

