/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiScreen;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiList;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiProvider;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.SliderState;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DislocatorGui
implements GuiProvider {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.dislocator");
    public static final int GUI_WIDTH = 240;
    public static final int GUI_HEIGHT = 177;
    private final Player player;
    private List<DislocatorAdvanced.DislocatorTarget> targetList = new ArrayList<DislocatorAdvanced.DislocatorTarget>();
    private GuiList<Integer> scrollElement;
    private int selectedIndex = 0;
    private int lastAdded = -1;
    private int fuel = 0;
    private boolean editAdded = false;
    private static double lastPos = 0.0;
    private boolean posLoaded = false;
    private boolean draggingTarget = false;
    private boolean blinkMode = false;

    public DislocatorGui(Player player) {
        this.player = player;
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("advanced_dislocator"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui) {
        gui.initStandardGui(240, 177);
        GuiElement root = gui.getRoot();
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        int bgPad = 5;
        int scrollBarWidth = 10;
        GuiRectangle posBG = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)TOOLKIT.shadedBorder((GuiParent)root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)(bgPad + scrollBarWidth + 1)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)122.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)157.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)(-bgPad)));
        this.scrollElement = new GuiList<Integer>((GuiParent)root){

            public SliderState scrollState() {
                SliderState state = super.scrollState();
                return SliderState.forScrollBar(() -> ((SliderState)state).getPos(), e -> {
                    lastPos = e;
                    state.setPos(e.doubleValue());
                }, () -> ((SliderState)state).sliderRatio());
            }
        }.setDisplayBuilder((x$0, x$1) -> new TargetElement((GuiElement<?>)x$0, (int)x$1)).setItemSpacing(1.0);
        Constraints.bind(this.scrollElement, (ConstrainedGeometry)posBG, (double)1.0);
        GuiToolkit.VanillaBar vanillaBar = TOOLKIT.vanillaScrollBar(root, Axis.Y);
        ((GuiTexture)((GuiTexture)((GuiTexture)vanillaBar.container().constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)posBG.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)posBG.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)posBG.get(GeoParam.LEFT), (double)-1.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)scrollBarWidth));
        vanillaBar.slider().setSliderState(this.scrollElement.scrollState()).setScrollableElement(this.scrollElement);
        GuiRectangle infoBG = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)TOOLKIT.shadedBorder((GuiParent)root).fill(GuiToolkit.Palette.Slot::fill).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)posBG.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)posBG.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)(-bgPad)))).setTooltip(() -> List.of(Component.m_237113_((String)(ChatFormatting.AQUA + this.getTarget().getName())), Component.m_237113_((String)(ChatFormatting.GOLD + "X: " + (int)this.getTarget().getX())), Component.m_237113_((String)(ChatFormatting.GOLD + "Y: " + (int)this.getTarget().getY())), Component.m_237113_((String)(ChatFormatting.GOLD + "Z: " + (int)this.getTarget().getZ())), Component.m_237113_((String)(ChatFormatting.GOLD + (Screen.m_96638_() ? this.getTarget().getDimension().m_135782_().toString() : this.getTarget().getDimension().m_135782_().m_135815_())))));
        GuiText xLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)infoBG).setAlignment(Align.LEFT).setShadow(() -> BCConfig.darkMode).setTextSupplier(() -> Component.m_237113_((String)("X: " + (int)this.getTarget().getX()))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).setTextColour(GuiToolkit.Palette.Slot::text).setEnabled(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiText yLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)infoBG).setAlignment(Align.LEFT).setShadow(() -> BCConfig.darkMode).setTextSupplier(() -> Component.m_237113_((String)("Y: " + (int)this.getTarget().getY()))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)xLabel.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).setTextColour(GuiToolkit.Palette.Slot::text).setEnabled(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiText zLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)infoBG).setAlignment(Align.LEFT).setShadow(() -> BCConfig.darkMode).setTextSupplier(() -> Component.m_237113_((String)("Z: " + (int)this.getTarget().getZ()))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)yLabel.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).setTextColour(GuiToolkit.Palette.Slot::text).setEnabled(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiText dimLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)infoBG).setAlignment(Align.LEFT).setShadow(() -> BCConfig.darkMode).setTextSupplier(() -> Component.m_237113_((String)this.getTarget().getDimension().m_135782_().m_135815_())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)zLabel.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).setTextColour(GuiToolkit.Palette.Slot::text).setEnabled(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        infoBG.constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)dimLabel.get(GeoParam.BOTTOM), (double)2.0));
        GuiButton setHere = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("update", new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("update.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)15.0))).onPress(() -> DraconicNetwork.sendDislocatorMessage(7, output -> output.writeVarInt(this.selectedIndex))).setDisabled(() -> !this.hasTarget() || this.getTarget().isLocked());
        GuiButton fuel1 = ((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("add_1", new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("fuel_add_1.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)(-bgPad - 1)))).onPress(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(false).writeBoolean(false)));
        Constraints.size((ConstrainedGeometry)fuel1, (double)20.0, (double)13.0);
        GuiButton fuel16 = ((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("add_16", new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("fuel_add_16.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)fuel1.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)fuel1.get(GeoParam.TOP)))).onPress(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(true).writeBoolean(false)));
        Constraints.size((ConstrainedGeometry)fuel16, (double)28.0, (double)13.0);
        GuiButton fuelAll = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("add_all", new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("fuel_add_all.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)fuel16.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)fuel16.get(GeoParam.TOP)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)13.0))).onPress(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(false).writeBoolean(true)));
        GuiRectangle fuelBG = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)TOOLKIT.shadedBorder((GuiParent)root).fill(GuiToolkit.Palette.Slot::fill).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)fuel1.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiText fuelLabel = ((GuiText)new GuiText((GuiParent)fuelBG).setAlignment(Align.LEFT).setShadow(() -> BCConfig.darkMode).setTextSupplier(() -> TOOLKIT.translate("fuel", new Object[0]).m_130946_(" " + this.fuel)).setTooltip(new Component[]{TOOLKIT.translate("fuel.info", new Object[0])})).setTextColour(GuiToolkit.Palette.Slot::text);
        Constraints.bind((ConstrainedGeometry)fuelLabel, (ConstrainedGeometry)fuelBG, (double)2.0);
        int subWidth = 18;
        GuiButton addButton = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("add", new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("add.info", new Object[0])})).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)15.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)(-subWidth)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)fuelBG.get(GeoParam.TOP), (double)-3.0))).onPress(() -> this.addNew(0));
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).fill(-16777216).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)addButton.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)addButton.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)addButton.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.RIGHT)));
        GuiButton upBtn = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createBorderlessButton((GuiParent)root, (Component)Component.m_237119_()).setTooltip(new Component[]{TOOLKIT.translate("add_top.info", new Object[0])})).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)addButton.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)6.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)addButton.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).onPress(() -> this.addNew(1));
        GuiTexture upTex = new GuiTexture((GuiParent)upBtn, DEGuiTextures.get("dislocator/add_top"));
        Constraints.size((ConstrainedGeometry)upTex, (double)8.0, (double)8.0);
        Constraints.center((ConstrainedGeometry)upTex, (ConstrainedGeometry)upBtn);
        GuiButton dwnBtn = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createBorderlessButton((GuiParent)root, (Component)Component.m_237119_()).setTooltip(new Component[]{TOOLKIT.translate("add_bottom.info", new Object[0])})).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)addButton.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)6.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)addButton.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)infoBG.get(GeoParam.RIGHT), (double)-1.0))).onPress(() -> this.addNew(2));
        GuiTexture dwnTex = new GuiTexture((GuiParent)dwnBtn, DEGuiTextures.get("dislocator/add_bottom"));
        Constraints.size((ConstrainedGeometry)dwnTex, (double)8.0, (double)8.0);
        Constraints.center((ConstrainedGeometry)dwnTex, (ConstrainedGeometry)dwnBtn);
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("mode_" + (this.blinkMode ? "blink" : "tp"), new Object[0])).setTooltip(new Component[]{TOOLKIT.translate("right_click_mode.info", new Object[0])})).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)24.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)infoBG.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)addButton.get(GeoParam.TOP), (double)-2.0))).onPress(() -> DraconicNetwork.sendDislocatorMessage(5, output -> output.writeBoolean(!this.blinkMode))).getLabel().setWrap(true);
        gui.onTick(() -> this.detectChanges(gui));
    }

    private boolean hasTarget() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size();
    }

    private DislocatorAdvanced.DislocatorTarget getTarget() {
        return (DislocatorAdvanced.DislocatorTarget)((Object)DataUtils.safeGet(this.targetList, (int)this.selectedIndex, () -> new DislocatorAdvanced.DislocatorTarget(0.0, 0.0, 0.0, (ResourceKey<Level>)Level.f_46428_)));
    }

    private void addNew(int mode) {
        String tempName = (int)this.player.m_20185_() + " " + (int)this.player.m_20186_() + " " + (int)this.player.m_20189_();
        this.lastAdded = mode == 0 ? this.selectedIndex + 1 : (mode == 1 ? 0 : this.targetList.size());
        DraconicNetwork.sendDislocatorMessage(0, output -> output.writeByte(mode).writeVarInt(this.lastAdded).writeString(tempName));
    }

    private void detectChanges(ModularGui gui) {
        ItemStack stack = DislocatorAdvanced.findDislocator(this.player);
        if (stack.m_41619_() || !this.player.m_6084_()) {
            gui.getScreen().m_7379_();
            return;
        }
        int lastSize = this.targetList.size();
        this.targetList = ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).getTargetList(stack);
        int count = Math.max(12, this.targetList.size());
        if (this.lastAdded != -1 && this.targetList.size() != lastSize) {
            this.editAdded = true;
        }
        double lastPos = this.scrollElement.scrollState().getPos();
        if (count != this.scrollElement.getList().size()) {
            this.scrollElement.getList().clear();
            for (int i = 0; i < count; ++i) {
                this.scrollElement.add((Object)i);
            }
        }
        this.scrollElement.scrollState().setPos(lastPos);
        this.selectedIndex = ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).getSelectedIndex(stack);
        this.fuel = ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).getFuel(stack);
        this.blinkMode = ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).getBlinkMode(stack);
        if (this.editAdded && this.lastAdded == 0) {
            this.scrollElement.scrollState().setPos(0.0);
        } else if (this.editAdded && this.lastAdded == this.targetList.size() - 1) {
            this.scrollElement.scrollState().setPos(1.0);
        }
        if (!this.posLoaded) {
            this.scrollElement.scrollState().setPos(DislocatorGui.lastPos);
            this.posLoaded = true;
        }
    }

    public static class Screen
    extends ModularGuiScreen {
        public Screen(Component title, Player player) {
            super((GuiProvider)new DislocatorGui(player));
            this.getModularGui().setGuiTitle(title);
        }
    }

    private class TargetElement
    extends GuiElement<TargetElement>
    implements BackgroundRender {
        private int index;
        private GuiTextField field;
        private String name;
        private GuiButton lock;
        private GuiButton delete;
        private int clickTime;
        private boolean mousePressed;
        private boolean dragging;
        boolean lastTickTarget;

        public TargetElement(GuiElement<?> parent, int index) {
            super(parent);
            this.name = "";
            this.clickTime = 99;
            this.mousePressed = false;
            this.dragging = false;
            this.lastTickTarget = false;
            this.index = index;
            this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
            this.setTooltip(List.of(this.getName().m_130940_(ChatFormatting.AQUA), TOOLKIT.translate("right_click_tp", new Object[0]).m_130940_(ChatFormatting.GRAY), TOOLKIT.translate("double_click_name", new Object[0]).m_130940_(ChatFormatting.GRAY), TOOLKIT.translate("must_unlock", new Object[0]).m_130940_(ChatFormatting.GRAY), TOOLKIT.translate("drag_to_move", new Object[0]).m_130940_(ChatFormatting.GRAY)));
            this.lock = (GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createIconButton((GuiParent)this, 8, 8, () -> DEGuiTextures.get("dislocator/" + (this.isLocked() ? "locked" : "unlocked"))).setTooltip(new Component[]{TOOLKIT.translate("edit_lock.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-9.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).onPress(() -> DraconicNetwork.sendDislocatorMessage(3, e -> e.writeVarInt(index).writeBoolean(!this.isLocked()))).setEnabled(this::hasTarget);
            this.delete = (GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createIconButton((GuiParent)this, 8, 8, DEGuiTextures.getter("dislocator/delete")).setTooltip(new Component[]{TOOLKIT.translate("delete.info", new Object[0])})).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.lock.get(GeoParam.LEFT), (double)-9.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).onPress(() -> DraconicNetwork.sendDislocatorMessage(1, e -> e.writeVarInt(index))).setEnabled(() -> this.hasTarget() && !this.isLocked());
            this.field = (GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField((GuiParent)this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)1.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).setFocusable(false).setEnterPressed(() -> this.field.setFocus(false)).setEnabled(this::hasTarget);
            Constraints.size((ConstrainedGeometry)this.field, (double)100.0, (double)10.0);
            this.field.setTextState(TextState.create(() -> this.name, this::setName));
        }

        private boolean hasTarget() {
            return this.index >= 0 && this.index < DislocatorGui.this.targetList.size();
        }

        private DislocatorAdvanced.DislocatorTarget getTarget() {
            return DislocatorGui.this.targetList.get(this.index);
        }

        private boolean isLocked() {
            return this.hasTarget() && this.getTarget().isLocked();
        }

        private MutableComponent getName() {
            return Component.m_237113_((String)(this.hasTarget() ? this.getTarget().getName() : "[error]"));
        }

        private void setName(String name) {
            this.name = name;
            DraconicNetwork.sendDislocatorMessage(2, e -> e.writeVarInt(this.index).writeString(name));
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean ret = false;
            if (!this.hasTarget() || button == 2) {
                return false;
            }
            boolean mouseOver = this.field.isMouseOver();
            if (mouseOver && button == 1) {
                DraconicNetwork.sendDislocatorMessage(8, e -> e.writeVarInt(this.index));
                this.getModularGui().getScreen().m_7379_();
                return true;
            }
            if (mouseOver && button == 0 && !this.getTarget().isLocked()) {
                if (this.clickTime <= 10) {
                    this.field.setFocus(true);
                    ret = true;
                } else {
                    this.clickTime = 0;
                }
            }
            ret = ret || super.mouseClicked(mouseX, mouseY, button);
            this.mousePressed = mouseOver;
            if (!ret && mouseOver && this.index != DislocatorGui.this.selectedIndex) {
                DraconicNetwork.sendDislocatorMessage(4, e -> e.writeVarInt(this.index));
                return true;
            }
            return ret;
        }

        public void mouseMoved(double mouseX, double mouseY) {
            if (this.mousePressed && !this.isMouseOver()) {
                DislocatorGui.this.draggingTarget = true;
                this.dragging = true;
            }
            super.mouseMoved(mouseX, mouseY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            TargetElement hovered;
            if (this.dragging && (hovered = this.getHovered()) != null) {
                int moveIndex = mouseY > hovered.yMin() + hovered.ySize() / 2.0 ? hovered.index + 1 : hovered.index;
                DraconicNetwork.sendDislocatorMessage(10, e -> e.writeVarInt(moveIndex));
            }
            DislocatorGui.this.draggingTarget = false;
            this.mousePressed = false;
            this.dragging = false;
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            boolean selected = false;
            boolean hovered = false;
            if (this.hasTarget() && (this.dragging || !DislocatorGui.this.draggingTarget)) {
                DislocatorAdvanced.DislocatorTarget target = this.getTarget();
                int margin = target.isLocked() ? 10 : 18;
                hovered = mouseX < this.xMax() - (double)margin && this.isMouseOver();
                selected = this.index == DislocatorGui.this.selectedIndex;
            }
            Material mat = DEGuiTextures.get("dislocator/slot");
            Material matSelect = DEGuiTextures.get("dislocator/slot_selected");
            render.texRect(selected ? matSelect : mat, this.xMin(), this.yMin(), this.xSize(), this.ySize());
            if (hovered && !selected) {
                render.texRect(matSelect, this.xMin(), this.yMin(), this.xSize(), this.ySize(), 0x30FFFFFF);
            }
        }

        public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
            if (this.dragging) {
                double yPos = MathHelper.clip((double)(mouseY - 6.0), (double)this.getParent().yMin(), (double)(this.getParent().yMax() - 12.0));
                TargetElement hovered = this.getHovered();
                if (hovered != null) {
                    double y = mouseY > hovered.yMin() + hovered.ySize() / 2.0 ? hovered.yMax() : hovered.yMin() - 1.0;
                    render.rect(this.xMin(), y, this.xSize(), 3.0, 0x6000FF00);
                }
                render.texRect(DEGuiTextures.get("dislocator/slot_selected"), this.xMin(), yPos, this.xSize(), this.ySize(), 0x60FFFFFF);
                return true;
            }
            if (DislocatorGui.this.draggingTarget) {
                return false;
            }
            return super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed);
        }

        private TargetElement getHovered() {
            for (GuiElement element : DislocatorGui.this.scrollElement.getElementMap().values()) {
                if (element == this || !element.isMouseOver() || !(element instanceof TargetElement)) continue;
                TargetElement targetElement = (TargetElement)element;
                return targetElement;
            }
            return null;
        }

        public void tick(double mouseX, double mouseY) {
            boolean hasTarget = this.hasTarget();
            if (hasTarget) {
                if (!this.field.isFocused() || DislocatorGui.this.lastAdded == this.index && DislocatorGui.this.editAdded) {
                    this.name = this.getTarget().getName();
                }
                if (!this.field.isFocused()) {
                    this.field.setCursorPosition(0);
                    this.field.setHighlightPos(0);
                }
            } else {
                this.name = "";
            }
            ++this.clickTime;
            this.lastTickTarget = hasTarget;
            if (DislocatorGui.this.lastAdded == this.index && DislocatorGui.this.editAdded) {
                DislocatorGui.this.lastAdded = -1;
                DislocatorGui.this.editAdded = false;
                this.field.setFocus(true);
                this.field.moveCursorToEnd(false);
                this.field.setHighlightPos(0);
            }
        }

        public boolean isTooltipEnabled() {
            return this.hasTarget();
        }
    }
}

