/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules;

import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public interface ModuleType<T extends ModuleData<T>> {
    default public int maxInstallable() {
        return -1;
    }

    default public InstallResult areModulesCompatible(Module<T> thisModule, Module<?> otherModule) {
        return new InstallResult(InstallResult.InstallResultType.YES, thisModule, null, (List<Component>)null);
    }

    default public T getData(Module<?> module) {
        return (T)((ModuleData)SneakyUtils.unsafeCast(module.getData()));
    }

    public int getDefaultWidth();

    public int getDefaultHeight();

    public String getName();

    default public Component getDisplayName() {
        return Component.m_237115_((String)("module_type.draconicevolution." + this.getName() + ".name"));
    }

    public ModuleEntity createEntity(Module<T> var1);

    default public void getTypeProperties(@Nullable T moduleData, Map<ConfigProperty, Consumer<T>> propertyMap) {
    }

    default public void getAttributeModifiers(@Nullable T moduleData, EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
    }

    public Collection<ModuleCategory> getCategories();
}

