/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AssemblerLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AutoWorkbenchLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.DieselGeneratorLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ExcavatorLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FermenterLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.RefineryLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SiloLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SqueezerLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixerLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillLogic;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ArcFurnaceCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AssemblerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AutoWorkbenchCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.BottlingMachineCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CapacitorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CrusherCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.DieselGenCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.EnergyMeterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ExcavatorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FermenterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FloodlightCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.MixerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.MultiblockCallbackWrapper;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.RefineryCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SampleDrillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SawmillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SiloCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SqueezerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.TeslaCoilCallbacks;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;

public class Callbacks {
    private static final Map<ResourceLocation, CallbackOwner<?>> CALLBACKS = new HashMap();
    private static boolean initialized = false;

    private static <T extends BlockEntity> void registerMB(MultiblockBEType<T> type, CallbackOwner<T> owner) {
        Callbacks.register(type.dummyHolder(), owner);
        Callbacks.register(type.masterHolder(), owner);
    }

    private static <S extends IMultiblockState> void registerMB(MultiblockRegistration<S> type, Callback<S> owner, String name, BlockPos ... valid) {
        MultiblockCallbackWrapper<S> wrapped = new MultiblockCallbackWrapper<S>(owner, type, name, valid);
        CALLBACKS.put(type.id().m_247266_(s -> s + "_master"), wrapped);
        CALLBACKS.put(type.id().m_247266_(s -> s + "_dummy"), wrapped);
    }

    private static <T extends BlockEntity> void register(RegistryObject<BlockEntityType<T>> type, CallbackOwner<T> owner) {
        CALLBACKS.put(type.getId(), owner);
    }

    private static void ensureInitialized() {
        if (initialized) {
            return;
        }
        Callbacks.registerMB(IEMultiblockLogic.CRUSHER, new CrusherCallbacks(), "crusher", CrusherLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.ARC_FURNACE, new ArcFurnaceCallbacks(), "arc_furnace", ArcFurnaceLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.BOTTLING_MACHINE, new BottlingMachineCallbacks(), "bottling_machine", BottlingMachineLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.DIESEL_GENERATOR, new DieselGenCallbacks(), "diesel_generator", DieselGeneratorLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.EXCAVATOR, new ExcavatorCallbacks(), "exavator", ExcavatorLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.FERMENTER, new FermenterCallbacks(), "fermenter", FermenterLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.SQUEEZER, new SqueezerCallbacks(), "squeezer", SqueezerLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.MIXER, new MixerCallbacks(), "mixer", MixerLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.REFINERY, new RefineryCallbacks(), "refinery", RefineryLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.ASSEMBLER, new AssemblerCallbacks(), "assembler", AssemblerLogic.REDSTONE_PORTS);
        Callbacks.registerMB(IEMultiblockLogic.AUTO_WORKBENCH, new AutoWorkbenchCallbacks(), "auto_workbench", AutoWorkbenchLogic.REDSTONE_POS);
        Callbacks.registerMB(IEMultiblockLogic.SILO, new SiloCallbacks(), "silo", SiloLogic.OUTPUT_POS);
        Callbacks.registerMB(IEMultiblockLogic.SAWMILL, new SawmillCallbacks(), "sawmill", SawmillLogic.REDSTONE_POS);
        Callbacks.register(IEBlockEntities.CAPACITOR_LV, new CapacitorCallbacks("lv"));
        Callbacks.register(IEBlockEntities.CAPACITOR_MV, new CapacitorCallbacks("mv"));
        Callbacks.register(IEBlockEntities.CAPACITOR_HV, new CapacitorCallbacks("hv"));
        Callbacks.register(IEBlockEntities.FLOODLIGHT, new FloodlightCallbacks());
        Callbacks.registerMB(IEBlockEntities.ENERGY_METER, new EnergyMeterCallbacks());
        Callbacks.registerMB(IEBlockEntities.SAMPLE_DRILL, new SampleDrillCallbacks());
        Callbacks.registerMB(IEBlockEntities.TESLACOIL, new TeslaCoilCallbacks());
        initialized = true;
    }

    public static Map<ResourceLocation, CallbackOwner<?>> getCallbacks() {
        Callbacks.ensureInitialized();
        return Collections.unmodifiableMap(CALLBACKS);
    }
}

