/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.items.BulletItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TurretMenu
extends IEContainerMenu {
    public final TurretContext data;

    protected TurretMenu(TurretContext ctx) {
        super(ctx.ctx);
        int i;
        this.data = ctx;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)ctx.invPlayer, j + i * 9 + 9, 8 + j * 18, 109 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)ctx.invPlayer, i, 8 + i * 18, 167));
        }
        this.addGenericData(GenericContainerData.energy(ctx.energy));
        this.addGenericData(new GenericContainerData<List<String>>(GenericDataSerializers.STRINGS, ctx.targetList));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.whitelist));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackAnimals));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackPlayers));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackNeutrals));
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.m_128425_("add", 8)) {
            this.data.targetList.get().add(nbt.m_128461_("add"));
        }
        if (nbt.m_128425_("remove", 3)) {
            this.data.targetList.get().remove(nbt.m_128451_("remove"));
        }
        if (nbt.m_128425_("whitelist", 1)) {
            this.data.whitelist.set(nbt.m_128471_("whitelist"));
        }
        if (nbt.m_128425_("attackAnimals", 1)) {
            this.data.attackAnimals.set(nbt.m_128471_("attackAnimals"));
        }
        if (nbt.m_128425_("attackPlayers", 1)) {
            this.data.attackPlayers.set(nbt.m_128471_("attackPlayers"));
        }
        if (nbt.m_128425_("attackNeutrals", 1)) {
            this.data.attackNeutrals.set(nbt.m_128471_("attackNeutrals"));
        }
        this.data.afterChange.run();
    }

    public record TurretContext(IEContainerMenu.MenuContext ctx, Inventory invPlayer, IMutableEnergyStorage energy, GetterAndSetter<List<String>> targetList, Runnable afterChange, GetterAndSetter<Boolean> whitelist, GetterAndSetter<Boolean> attackAnimals, GetterAndSetter<Boolean> attackPlayers, GetterAndSetter<Boolean> attackNeutrals) {
        public static TurretContext serverCtx(MenuType<?> type, int id, Inventory invPlayer, TurretBlockEntity<?> be) {
            return new TurretContext(IEContainerMenu.blockCtx(type, id, be), invPlayer, be.energyStorage, new GetterAndSetter<List<String>>(() -> be.targetList, l -> {
                be.targetList = l;
            }), be::resetTarget, new GetterAndSetter<Boolean>(() -> be.whitelist, b -> {
                be.whitelist = b;
            }), new GetterAndSetter<Boolean>(() -> be.attackAnimals, b -> {
                be.attackAnimals = b;
            }), new GetterAndSetter<Boolean>(() -> be.attackPlayers, b -> {
                be.attackPlayers = b;
            }), new GetterAndSetter<Boolean>(() -> be.attackNeutrals, b -> {
                be.attackNeutrals = b;
            }));
        }

        public static TurretContext clientCtx(MenuType<?> type, int id, Inventory invPlayer) {
            return new TurretContext(IEContainerMenu.clientCtx(type, id), invPlayer, new MutableEnergyStorage(16000), GetterAndSetter.standalone(List.of()), () -> {}, GetterAndSetter.standalone(false), GetterAndSetter.standalone(false), GetterAndSetter.standalone(false), GetterAndSetter.standalone(false));
        }
    }

    public static class GunTurretMenu
    extends TurretMenu {
        public final GetterAndSetter<Boolean> expelCasings;

        public static GunTurretMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, TurretGunBlockEntity be) {
            return new GunTurretMenu(TurretContext.serverCtx(type, id, invPlayer, be), (IItemHandler)new ItemStackHandler(be.getInventory()), new GetterAndSetter<Boolean>(() -> be.expelCasings, b -> {
                be.expelCasings = b;
            }));
        }

        public static GunTurretMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
            return new GunTurretMenu(TurretContext.clientCtx(type, id, invPlayer), (IItemHandler)new ItemStackHandler(2), GetterAndSetter.standalone(false));
        }

        private GunTurretMenu(TurretContext ctx, IItemHandler inv, GetterAndSetter<Boolean> expelCasings) {
            super(ctx);
            this.expelCasings = expelCasings;
            this.m_38897_((Slot)new IESlot.Bullet(inv, 0, 134, 13, 64){

                @Override
                public boolean m_5857_(ItemStack itemStack) {
                    if (!super.m_5857_(itemStack)) {
                        return false;
                    }
                    BulletHandler.IBullet bullet = ((BulletItem)itemStack.m_41720_()).getType();
                    return bullet != null && bullet.isValidForTurret();
                }
            });
            this.m_38897_((Slot)new IESlot.NewOutput(inv, 1, 134, 49));
            this.ownSlotCount = 2;
            this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, expelCasings));
        }

        @Override
        public void receiveMessageFromScreen(CompoundTag nbt) {
            super.receiveMessageFromScreen(nbt);
            if (nbt.m_128425_("expelCasings", 1)) {
                this.expelCasings.set(nbt.m_128471_("expelCasings"));
            }
        }
    }

    public static class ChemTurretMenu
    extends TurretMenu {
        public final FluidTank tank;
        public final GetterAndSetter<Boolean> ignite;

        public static ChemTurretMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, TurretChemBlockEntity be) {
            return new ChemTurretMenu(TurretContext.serverCtx(type, id, invPlayer, be), be.tank, new GetterAndSetter<Boolean>(() -> be.ignite, b -> {
                be.ignite = b;
            }));
        }

        public static ChemTurretMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
            return new ChemTurretMenu(TurretContext.clientCtx(type, id, invPlayer), new FluidTank(4000), GetterAndSetter.standalone(false));
        }

        private ChemTurretMenu(TurretContext ctx, FluidTank tank, GetterAndSetter<Boolean> ignite) {
            super(ctx);
            this.tank = tank;
            this.ignite = ignite;
            this.addGenericData(GenericContainerData.fluid(tank));
            this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ignite));
        }

        @Override
        public void receiveMessageFromScreen(CompoundTag nbt) {
            super.receiveMessageFromScreen(nbt);
            if (nbt.m_128425_("ignite", 1)) {
                this.ignite.set(nbt.m_128471_("ignite"));
            }
        }
    }
}

