/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorRedstoneBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IRedstoneConnector {
    public IEEnums.IOSideConfig ioMode = IEEnums.IOSideConfig.INPUT;
    public DyeColor redstoneChannel = DyeColor.WHITE;
    public boolean rsDirty = false;
    private int output;

    public ConnectorRedstoneBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_REDSTONE.get()), pos, state);
    }

    public ConnectorRedstoneBlockEntity(BlockEntityType<? extends ConnectorRedstoneBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickServer() {
        if (this.rsDirty) {
            this.globalNet.getLocalNet(this.f_58858_).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        }
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (side == this.getFacing().m_122424_()) {
            return this.getWeakRSOutput(side);
        }
        return 0;
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (!this.isRSOutput() || side == this.getFacing()) {
            return 0;
        }
        return this.output;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return side != this.getFacing().m_122424_();
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.f_58857_.f_46443_ && SafeChunkUtils.isChunkSafe((LevelAccessor)this.f_58857_, this.f_58858_)) {
            this.output = handler.getValue(this.redstoneChannel.m_41060_());
            if (!this.m_58901_() && this.isRSOutput()) {
                this.m_6596_();
                this.markContainingBlockForUpdate(this.m_58900_());
                BlockPos offsetPos = this.f_58858_.m_121945_(this.getFacing());
                this.f_58857_.m_46672_(offsetPos, this.f_58857_.m_8055_(offsetPos).m_60734_());
            }
        }
    }

    public boolean isRSInput() {
        return this.ioMode == IEEnums.IOSideConfig.INPUT;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.isRSInput()) {
            signals[this.redstoneChannel.m_41060_()] = (byte)this.getMaxRSInput();
        }
        this.rsDirty = false;
    }

    protected boolean acceptSignalFrom(Direction side) {
        BlockPos offset = this.f_58858_.m_121945_(side);
        BlockEntity te = SafeChunkUtils.getSafeBE((LevelAccessor)this.f_58857_, offset);
        if (!(te instanceof ConnectorRedstoneBlockEntity)) {
            return true;
        }
        ConnectorRedstoneBlockEntity rsConnector = (ConnectorRedstoneBlockEntity)te;
        if (!this.getLocalNet(0).getConnectors().contains(offset)) {
            return true;
        }
        return rsConnector.redstoneChannel != this.redstoneChannel;
    }

    @Override
    protected int getRSInput(Direction from) {
        if (this.acceptSignalFrom(from)) {
            return super.getRSInput(from);
        }
        return 0;
    }

    public boolean isRSOutput() {
        return this.ioMode == IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.f_58857_.f_46443_) {
            ImmersiveEngineering.proxy.openTileScreen("redstoneconnector", this);
        }
        return InteractionResult.SUCCESS;
    }

    protected void updateAfterConfigure() {
        this.m_6596_();
        this.globalNet.getLocalNet(this.f_58858_).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        this.markContainingBlockForUpdate(null);
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 254, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128441_("ioMode")) {
            this.ioMode = IEEnums.IOSideConfig.VALUES[message.m_128451_("ioMode")];
        }
        if (message.m_128441_("redstoneChannel")) {
            this.redstoneChannel = DyeColor.m_41053_((int)message.m_128451_("redstoneChannel"));
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("ioMode", this.ioMode.ordinal());
        nbt.m_128405_("redstoneChannel", this.redstoneChannel.m_41060_());
        nbt.m_128405_("output", this.output);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.ioMode = IEEnums.IOSideConfig.VALUES[nbt.m_128451_("ioMode")];
        this.redstoneChannel = DyeColor.m_41053_((int)nbt.m_128451_("redstoneChannel"));
        this.output = nbt.m_128451_("output");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().m_122424_();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 - conRadius * (double)side.m_122429_(), 0.5 - conRadius * (double)side.m_122430_(), 0.5 - conRadius * (double)side.m_122431_());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), 0.625f);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{Component.m_237110_((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.m_118938_((String)("item.minecraft.firework_star." + this.redstoneChannel.m_41065_()), (Object[])new Object[0])}), Component.m_237115_((String)("desc.immersiveengineering.info.blockSide.io." + this.ioMode.m_7912_()))};
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int oldRSIn = this.getMaxRSInput();
        super.onNeighborBlockChange(otherPos);
        if (this.isRSInput() && oldRSIn != this.getMaxRSInput()) {
            this.rsDirty = true;
        }
    }
}

