/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record RequestToJoinTeam(UUID team) {

    public static class Serializer
    implements PacketSerializer<RequestToJoinTeam> {
        public Class<RequestToJoinTeam> messageClass() {
            return RequestToJoinTeam.class;
        }

        public void encode(RequestToJoinTeam msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.team);
        }

        public RequestToJoinTeam decode(FriendlyByteBuf buffer) {
            return new RequestToJoinTeam(buffer.m_130259_());
        }
    }

    public static class Handler
    implements PacketHandler<RequestToJoinTeam> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(RequestToJoinTeam msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (!PermissionsConfig.selfManage && !player.m_20310_(2)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.join_request"));
                return true;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeam(msg.team);
            if (team == null) {
                return true;
            }
            if (data.hasPlayerTeam((Player)player)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team"));
                return true;
            }
            if (!team.allowsJoinRequests()) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.team_join_request"));
                return true;
            }
            team.sendJoinRequest((Player)player);
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.join_request", (Object[])new Object[]{team.getName()}));
            return true;
        }
    }
}

