/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeamInfoScreen
extends BaseScreen
implements LoadingResultHandler {
    private static final MutableComponent CONFIG_SELF_MANAGEMENT = Component.m_237115_((String)"skyblockbuilder.command.disabled.join_request").m_130940_(ChatFormatting.RED);
    private static final MutableComponent TEAM_JOIN_REQUESTS = Component.m_237115_((String)"skyblockbuilder.command.disabled.team_join_request").m_130940_(ChatFormatting.RED);
    private static final MutableComponent CONFIG_ALLOW_VISITS = Component.m_237115_((String)"skyblockbuilder.command.disabled.team_visit").m_130940_(ChatFormatting.RED);
    private static final MutableComponent TEAM_ALLOW_VISITS = Component.m_237115_((String)"skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED);
    private static final MutableComponent USER_HAS_TEAM = Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED);
    private static final MutableComponent VISIT_TEAM = ComponentBuilder.text("visit_team", new Object[0]);
    private static final MutableComponent REQUEST_TO_JOIN = ComponentBuilder.text("request_to_join", new Object[0]);
    private static final MutableComponent REQUESTED_TO_JOIN = ComponentBuilder.text("requested_to_join", new Object[0]).m_130940_(ChatFormatting.GREEN);
    private final Team team;
    private final BaseScreen prev;
    private Button visitButton;

    public TeamInfoScreen(Team team, BaseScreen prev) {
        super((Component)Component.m_237113_((String)team.getName()), 245, 85);
        this.team = team;
        this.prev = prev;
    }

    protected void m_7856_() {
        Button joinButton = Button.m_253074_((Component)(this.alreadySentJoinRequest() ? REQUESTED_TO_JOIN : REQUEST_TO_JOIN), button -> {
            SkyGUIs.getNetwork().requestToJoinTeam(this.team);
            this.getLoadingCircle().setActive(true);
        }).m_252987_(this.x(10), this.y(30), 110, 20).m_253136_();
        if (SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).hasPlayerTeam((Player)Minecraft.m_91087_().f_91074_)) {
            joinButton.m_257544_(Tooltip.m_257550_((Component)USER_HAS_TEAM));
        } else if (!PermissionsConfig.selfManage) {
            joinButton.m_257544_(Tooltip.m_257550_((Component)CONFIG_SELF_MANAGEMENT));
        } else if (!this.team.allowsJoinRequests()) {
            joinButton.m_257544_(Tooltip.m_257550_((Component)TEAM_JOIN_REQUESTS));
        }
        joinButton.f_93623_ = PermissionsConfig.selfManage && this.team.allowsJoinRequests() && !this.alreadySentJoinRequest() && !SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).hasPlayerTeam((Player)Minecraft.m_91087_().f_91074_);
        this.m_142416_((GuiEventListener)joinButton);
        this.visitButton = Button.m_253074_((Component)VISIT_TEAM, button -> {
            SkyGUIs.getNetwork().visitTeam(this.team);
            this.getLoadingCircle().setActive(true);
        }).m_252987_(this.x(125), this.y(30), 110, 20).m_253136_();
        if (!this.f_96541_.f_91074_.m_20310_(1)) {
            if (!PermissionsConfig.Teleports.allowVisits) {
                this.visitButton.m_257544_(Tooltip.m_257550_((Component)CONFIG_ALLOW_VISITS));
            } else if (!this.team.allowsVisits()) {
                this.visitButton.m_257544_(Tooltip.m_257550_((Component)TEAM_ALLOW_VISITS));
            }
        }
        this.visitButton.f_93623_ = this.f_96541_.f_91074_.m_20310_(1) || PermissionsConfig.Teleports.allowVisits && this.team.allowsVisits();
        this.m_142416_((GuiEventListener)this.visitButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)).m_252987_(this.x(10), this.y(55), 226, 20).m_253136_());
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        Minecraft minecraft = Minecraft.m_91087_();
        switch (result.status()) {
            case SUCCESS: {
                minecraft.f_91080_ = null;
                minecraft.f_91074_.m_213846_(result.reason());
                break;
            }
            case FAIL: {
                minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
            }
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(player.m_20310_(1) || PermissionsConfig.Teleports.allowVisits && this.team.allowsVisits())) {
            return;
        }
        SkyMeta metaInfo = data.getOrCreateMetaInfo((Player)player);
        if (metaInfo.canVisit(level.m_46467_())) {
            this.visitButton.m_257544_(null);
            this.visitButton.f_93623_ = true;
            return;
        }
        this.visitButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.visitCooldown - (level.m_46467_() - metaInfo.getLastVisitTeleport())))})));
        this.visitButton.f_93623_ = false;
    }

    private boolean alreadySentJoinRequest() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && this.team.getJoinRequests().contains(player.m_20148_());
    }
}

