/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class EditSpawnsScreen
extends ListScreen<BlockPos>
implements LoadingResultHandler {
    private final Team team;
    private final BaseScreen prev;
    private Button removeButton;
    private Checkbox selectAll;
    private int selectedAmount = 0;
    private Runnable onSuccess;

    public EditSpawnsScreen(Team team, BaseScreen prev) {
        super((Component)ComponentBuilder.text("remove_spawns", new Object[0]), team.getPossibleSpawns().stream().map(TemplatesConfig.Spawn::pos).toList(), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
        this.team = team;
        this.prev = prev;
    }

    @Override
    protected void m_7856_() {
        this.removeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.text("remove", new Object[0]), button -> {
            List positions = this.getSelectedValues().stream().toList();
            Minecraft.m_91087_().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_remove_spawns", positions.size()), () -> {
                SkyGUIs.getNetwork().handleRemoveSpawns(new HashSet<BlockPos>(positions));
                this.onSuccess = () -> Minecraft.m_91087_().m_91152_((Screen)this.prev);
            }));
        }).m_252987_(this.x(10), this.y(200), 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)).m_252987_(this.x(77), this.y(200), 95, 20).m_253136_());
        this.selectAll = (Checkbox)this.m_142416_((GuiEventListener)new SizeableCheckbox(this.x(9), this.y(32), 14, false, this.allSelected() ? UNSELECT_ALL : SELECT_ALL){

            public void m_5691_() {
                super.m_5691_();
                if (this.f_93822_) {
                    EditSpawnsScreen.this.selectAll();
                } else {
                    EditSpawnsScreen.this.unselectAll();
                }
                EditSpawnsScreen.this.updateButtons();
            }
        });
        super.m_7856_();
        this.updateButtons();
    }

    @Override
    protected int entriesPerPage() {
        return 10;
    }

    @Override
    protected void fillWidgets() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.addCheckboxWidget(this.renderArea.addRenderableWidget2(new SpawnWidget((BlockPos)this.values.get(i), this, 0, 14 * i, 100, 12)));
        }
    }

    @Override
    public void render_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, (Component)ComponentBuilder.text("selected_amount", this.selectedAmount), this.x(28), this.y(35), Color.DARK_GRAY.getRGB(), false);
    }

    public void updateButtons() {
        List selectedIds = this.getSelectedValues().stream().sorted().toList();
        this.removeButton.f_93623_ = this.getSelectedValues().size() < this.getValues().size();
        this.selectAll.f_93822_ = this.allSelected();
        this.selectedAmount = selectedIds.size();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean ret = super.m_6375_(mouseX, mouseY, button);
        this.updateButtons();
        return ret;
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        switch (result.status()) {
            case SUCCESS: {
                this.onSuccess.run();
                break;
            }
            case FAIL: {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
            }
        }
    }

    protected class SpawnWidget
    extends ListScreen.CheckboxTextWidget {
        public SpawnWidget(BlockPos value, Screen screen, int x, int y, int width, int height) {
            super(value, screen, x, y, width, height, (Component)Component.m_237113_((String)(value.m_123341_() + " " + value.m_123342_() + " " + value.m_123343_())));
        }
    }
}

