/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrashCanBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.125, (double)0.75, (double)0.125, (double)0.875, (double)0.8125, (double)0.875), Shapes.m_83048_((double)0.1875, (double)0.78125, (double)0.1875, (double)0.8125, (double)0.84375, (double)0.8125)});
    private final Supplier<BaseBlockEntityType<?>> blockEntityType;
    private final BiFunction<Player, BlockPos, TrashCanContainer> containerProvider;

    public TrashCanBlock(Supplier<BaseBlockEntityType<?>> blockEntityType, BiFunction<Player, BlockPos, TrashCanContainer> containerProvider) {
        super(false, BlockProperties.create().mapColor(MapColor.f_283818_).sound(SoundType.f_56743_).destroyTime(1.5f).explosionResistance(6.0f).requiresCorrectTool());
        this.blockEntityType = blockEntityType;
        this.containerProvider = containerProvider;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (!level.f_46443_) {
            CommonUtils.openContainer((BaseContainer)((BaseContainer)this.containerProvider.apply(player, pos)));
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    protected void appendItemInformation(ItemStack stack, BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)("trashcans." + Registries.BLOCKS.getIdentifier((Object)this).m_135815_() + ".info")).color(ChatFormatting.GRAY).get());
    }
}

