/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46.batching;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.SectionPos;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.DrawBatchInternal;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.MagicNumbers;
import net.roguelogix.quartz.internal.MultiBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl46.GL46Buffer;
import net.roguelogix.quartz.internal.gl46.GL46Core;
import net.roguelogix.quartz.internal.gl46.GL46FeedbackDrawing;
import net.roguelogix.quartz.internal.gl46.GL46LightEngine;
import net.roguelogix.quartz.internal.gl46.batching.GL46DrawChunk;
import net.roguelogix.quartz.internal.gl46.batching.GL46Instance;
import net.roguelogix.quartz.internal.gl46.batching.GL46InstanceBatch;
import net.roguelogix.quartz.internal.gl46.batching.GL46InstanceManager;
import net.roguelogix.quartz.internal.util.IndirectDrawInfo;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Matrix4fc;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL45C;

@NonnullDefault
public class GL46DrawBatch
implements DrawBatchInternal {
    private boolean enabled = true;
    private boolean culled = false;
    @Nullable
    private AABB cullAABB = null;
    private Vector4f cullVector = new Vector4f();
    private Vector4f cullVectorMin = new Vector4f();
    private Vector4f cullVectorMax = new Vector4f();
    final MultiBuffer<GL46Buffer> instanceDataBuffer = new MultiBuffer(4, false);
    final Reference2ReferenceMap<InternalMesh, GL46InstanceManager> instanceManagers = new Reference2ReferenceOpenHashMap();
    final ReferenceSet<GL46InstanceManager> instanceBatches = new ReferenceOpenHashSet();
    final FastArraySet<GL46InstanceManager> dirtyBatches = new FastArraySet();
    final MultiBuffer<GL46Buffer> dynamicMatrixBuffer = new MultiBuffer(3, false);
    final DynamicMatrixManager dynamicMatrixManager = new DynamicMatrixManager(this.dynamicMatrixBuffer);
    final DynamicMatrix IDENTITY_DYNAMIC_MATRIX = this.dynamicMatrixManager.createMatrix(null, null);
    private final ReferenceArrayList<GL46LightEngine.ChunkHandle> cullLightChunks = new ReferenceArrayList();
    private final ReferenceArrayList<GL46LightEngine.ChunkHandle> instanceLightChunks = new ReferenceArrayList();
    private boolean instanceAABBsDirty = false;
    private int currentFrame = -1;
    private long[] instanceDataFences = new long[3];
    private final Reference2ReferenceMap<RenderType, ReferenceArrayList<GL46DrawChunk>> renderChunkLists = new Reference2ReferenceArrayMap();
    private final ReferenceArrayList<RenderType> usedRenderTypes = new ReferenceArrayList();
    private boolean indirectDirty = false;
    private int currentIndirectBuffer = 0;
    private MultiBuffer<GL46Buffer>[] indirectBuffers = new MultiBuffer[]{new MultiBuffer(3, false), new MultiBuffer(3, false)};
    private MultiBuffer.Allocation[] indirectBufferAllocs = new MultiBuffer.Allocation[2];
    private long[] indirectBufferFences = new long[2];
    private final Reference2IntMap<RenderType> verticesPerRenderType = new Reference2IntOpenHashMap();
    private final Reference2LongMap<RenderType>[] drawOffsets = new Reference2LongMap[3];

    public GL46DrawBatch() {
        for (int i = 0; i < this.drawOffsets.length; ++i) {
            this.drawOffsets[i] = new Reference2LongOpenHashMap();
        }
        ReferenceArrayList<RenderType> renderTypes = this.usedRenderTypes;
        MultiBuffer.Allocation[] indirectBuffers = this.indirectBufferAllocs;
        QuartzCore.mainThreadClean(this, () -> {
            for (int i = 0; i < indirectBuffers.length; ++i) {
                if (indirectBuffers[i] == null) continue;
                indirectBuffers[i].free();
            }
            renderTypes.forEach(GL46FeedbackDrawing::removeRenderTypeUse);
        });
    }

    @Override
    @Nullable
    public DrawBatch.Instance createInstance(Vector3ic position, Mesh mesh, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        DynamicMatrixManager.Matrix castedMatrix;
        InternalMesh castedMesh;
        block7: {
            block6: {
                if (!(mesh instanceof InternalMesh)) {
                    return null;
                }
                castedMesh = (InternalMesh)mesh;
                if (dynamicMatrix == null) {
                    dynamicMatrix = this.IDENTITY_DYNAMIC_MATRIX;
                }
                if (!(dynamicMatrix instanceof DynamicMatrixManager.Matrix)) break block6;
                castedMatrix = (DynamicMatrixManager.Matrix)dynamicMatrix;
                if (this.dynamicMatrixManager.owns(dynamicMatrix)) break block7;
            }
            return null;
        }
        if (staticMatrix == null) {
            staticMatrix = MagicNumbers.IDENTITY_MATRIX;
        }
        GL46InstanceManager instanceManager = (GL46InstanceManager)this.instanceManagers.computeIfAbsent((Object)castedMesh, internalMesh -> new GL46InstanceManager(this, (InternalMesh)internalMesh, true));
        return instanceManager.createInstance(position, castedMatrix, staticMatrix, aabb);
    }

    @Override
    @Nullable
    public DrawBatch.InstanceBatch createInstanceBatch(Mesh mesh) {
        if (!(mesh instanceof InternalMesh)) {
            return null;
        }
        InternalMesh castedMesh = (InternalMesh)mesh;
        return new GL46InstanceBatch(new GL46InstanceManager(this, castedMesh, false));
    }

    @Override
    public DynamicMatrix createDynamicMatrix(@Nullable Matrix4fc initialValue, @Nullable DynamicMatrix parentTransform, @Nullable DynamicMatrix.UpdateFunc updateFunc) {
        return this.dynamicMatrixManager.createMatrix(initialValue, updateFunc, parentTransform);
    }

    @Override
    public void setCullAABB(@Nullable AABB aabb) {
        if (aabb == null) {
            this.cullAABB = null;
            this.cullLightChunks.clear();
            return;
        }
        this.cullAABB = aabb;
        this.cullLightChunks.clear();
        for (int X = this.cullAABB.minX(); X < (this.cullAABB.maxX() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Y = this.cullAABB.minY(); Y < (this.cullAABB.maxY() + 16 & 0xFFFFFFF0); Y += 16) {
                for (int Z = this.cullAABB.minZ(); Z < (this.cullAABB.maxZ() + 16 & 0xFFFFFFF0); Z += 16) {
                    int chunkX = X >> 4;
                    int chunkY = Y >> 4;
                    int chunkZ = Z >> 4;
                    this.cullLightChunks.add((Object)GL46LightEngine.getChunk(SectionPos.m_123209_((int)chunkX, (int)chunkY, (int)chunkZ)));
                }
            }
        }
    }

    public void instanceAABBsDirty() {
        this.instanceAABBsDirty = true;
    }

    private void updateInstanceAABBs() {
        if (!this.instanceAABBsDirty) {
            return;
        }
        this.instanceAABBsDirty = false;
        AABB fullAABB = new AABB();
        for (GL46InstanceManager batch : this.instanceBatches) {
            for (WeakReference instanceRef : batch.instances) {
                GL46Instance instance = (GL46Instance)instanceRef.get();
                if (instance == null || instance.aabb == null) continue;
                fullAABB = fullAABB.union(instance.aabb);
            }
        }
        this.instanceLightChunks.clear();
        for (int X = fullAABB.minX(); X < (fullAABB.maxX() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Y = fullAABB.minY(); Y < (fullAABB.maxY() + 16 & 0xFFFFFFF0); Y += 16) {
                for (int Z = fullAABB.minZ(); Z < (fullAABB.maxZ() + 16 & 0xFFFFFFF0); Z += 16) {
                    int chunkX = X >> 4;
                    int chunkY = Y >> 4;
                    int chunkZ = Z >> 4;
                    this.instanceLightChunks.add((Object)GL46LightEngine.getChunk(SectionPos.m_123209_((int)chunkX, (int)chunkY, (int)chunkZ)));
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEmpty() {
        return this.instanceManagers.isEmpty() && this.instanceBatches.isEmpty();
    }

    @Override
    public void updateAndCull(DrawInfo drawInfo) {
        int i;
        this.currentFrame = GL46Core.INSTANCE.frameInFlight();
        this.indirectBuffers[this.currentIndirectBuffer].setActiveFrame(this.currentFrame);
        this.instanceDataBuffer.setActiveFrame(this.currentFrame);
        this.dynamicMatrixBuffer.setActiveFrame(this.currentFrame);
        this.dynamicMatrixManager.updateAll(drawInfo.deltaNano, drawInfo.partialTicks, drawInfo.playerPosition, drawInfo.playerSubBlock);
        if (!this.dirtyBatches.isEmpty()) {
            if (this.instanceDataFences[this.currentFrame] != 0L && GL45C.glIsSync((long)this.instanceDataFences[this.currentFrame])) {
                GL45C.glClientWaitSync((long)this.instanceDataFences[this.currentFrame], (int)1, (long)-1L);
            }
            for (i = 0; i < this.dirtyBatches.size(); ++i) {
                GL46InstanceManager batch = (GL46InstanceManager)this.dirtyBatches.get(i);
                if (batch.writeUpdates()) continue;
                this.dirtyBatches.remove((Object)batch);
                if (this.dirtyBatches.isEmpty()) break;
                --i;
            }
        }
        if (!this.enabled) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.cullAABB != null && !IrisDetection.areShadersActive()) {
            this.cullVectorMin.set(2.0f);
            this.cullVectorMax.set(-2.0f);
            for (i = 0; i < 8; ++i) {
                this.cullVector.set((float)(((i & 1) == 0 ? this.cullAABB.maxX() : this.cullAABB.minX()) - drawInfo.playerPosition.x), (float)(((i & 2) == 0 ? this.cullAABB.maxY() : this.cullAABB.minY()) - drawInfo.playerPosition.y), (float)(((i & 4) == 0 ? this.cullAABB.maxZ() : this.cullAABB.minZ()) - drawInfo.playerPosition.z), 1.0f);
                this.cullVector.sub(drawInfo.playerSubBlock.x, drawInfo.playerSubBlock.y, drawInfo.playerSubBlock.z, 0.0f);
                this.cullVector.mul((Matrix4fc)drawInfo.projectionMatrix);
                this.cullVector.div(this.cullVector.w);
                this.cullVectorMin.min((Vector4fc)this.cullVector);
                this.cullVectorMax.max((Vector4fc)this.cullVector);
            }
            this.culled = this.cullVectorMin.x > 1.0f || this.cullVectorMax.x < -1.0f || this.cullVectorMin.y > 1.0f || this.cullVectorMax.y < -1.0f || this.cullVectorMin.z > 1.0f || this.cullVectorMax.z < -1.0f;
        } else {
            this.culled = false;
        }
        if (this.culled) {
            return;
        }
        if (this.indirectDirty) {
            int totalChunks = 0;
            for (GL46InstanceManager value : this.instanceBatches) {
                totalChunks += value.drawChunks.size();
            }
            int newBufferIndex = (this.currentIndirectBuffer + 1) % this.indirectBufferFences.length;
            if (this.indirectBufferFences[newBufferIndex] != 0L) {
                if (GL45C.glIsSync((long)this.indirectBufferFences[newBufferIndex])) {
                    GL45C.glClientWaitSync((long)this.indirectBufferFences[newBufferIndex], (int)1, (long)-1L);
                }
                this.indirectBufferFences[newBufferIndex] = 0L;
            }
            MultiBuffer<GL46Buffer> indirectBuffer = this.indirectBuffers[newBufferIndex];
            MultiBuffer.Allocation alloc = this.indirectBufferAllocs[newBufferIndex] = indirectBuffer.realloc(this.indirectBufferAllocs[newBufferIndex], totalChunks * 4 * 4, totalChunks * 5 * 4, false);
            for (int i2 = 0; i2 < 3; ++i2) {
                indirectBuffer.setActiveFrame(i2);
                Buffer.Allocation activeAlloc = alloc.activeAllocation();
                PointerWrapper pointer = activeAlloc.address();
                int indexOffset = 0;
                for (Map.Entry value : this.renderChunkLists.entrySet()) {
                    int indirectByteOffset = indexOffset * 4;
                    int indirectDrawCount = ((ReferenceArrayList)value.getValue()).size();
                    long packedOffsets = (long)indirectByteOffset << 32 | (long)indirectDrawCount;
                    int totalVertices = 0;
                    for (GL46DrawChunk chunk : (ReferenceArrayList)value.getValue()) {
                        IndirectDrawInfo indirectInfo = chunk.indirectDrawInfo(i2);
                        totalVertices += indirectInfo.elementCount() * indirectInfo.instanceCount();
                        pointer.putIntIdx(indexOffset++, indirectInfo.elementCount());
                        pointer.putIntIdx(indexOffset++, indirectInfo.instanceCount());
                        pointer.putIntIdx(indexOffset++, indirectInfo.baseVertex());
                        pointer.putIntIdx(indexOffset++, indirectInfo.baseInstance());
                    }
                    this.drawOffsets[i2].put((Object)((RenderType)value.getKey()), packedOffsets);
                    this.verticesPerRenderType.put((Object)((RenderType)value.getKey()), totalVertices);
                }
            }
            this.renderChunkLists.keySet().forEach(GL46FeedbackDrawing::addRenderTypeUse);
            this.usedRenderTypes.forEach(GL46FeedbackDrawing::removeRenderTypeUse);
            this.usedRenderTypes.clear();
            this.usedRenderTypes.addAll((Collection)this.renderChunkLists.keySet());
            this.currentIndirectBuffer = newBufferIndex;
            this.indirectDirty = false;
        }
        GL45C.glBindBufferBase((int)37074, (int)0, (int)this.dynamicMatrixBuffer.activeBuffer().handle());
        GL45C.glBindBufferBase((int)37074, (int)1, (int)this.instanceDataBuffer.activeBuffer().handle());
        GL45C.glBindBufferBase((int)37074, (int)2, (int)this.instanceDataBuffer.buffer(3).handle());
        for (GL46InstanceManager value : this.instanceBatches) {
            GL45C.glUniform1ui((int)0, (int)(value.instanceDataAlloc.activeAllocation().offset() / 128));
            GL45C.glDispatchCompute((int)value.instanceCount(), (int)1, (int)1);
        }
    }

    void addDrawChunk(GL46DrawChunk chunk) {
        ReferenceArrayList components = (ReferenceArrayList)this.renderChunkLists.computeIfAbsent((Object)chunk.renderType, e -> new ReferenceArrayList());
        chunk.drawIndex = components.size();
        components.add((Object)chunk);
        this.setIndirectInfoDirty();
    }

    void removeDrawChunk(GL46DrawChunk chunk) {
        if (chunk.drawIndex == -1) {
            return;
        }
        ReferenceArrayList components = (ReferenceArrayList)this.renderChunkLists.get((Object)chunk.renderType);
        if (components == null) {
            return;
        }
        GL46DrawChunk lastChunk = (GL46DrawChunk)components.pop();
        this.setIndirectInfoDirty();
        if (lastChunk == chunk) {
            chunk.drawIndex = -1;
            return;
        }
        lastChunk.drawIndex = chunk.drawIndex;
        chunk.drawIndex = -1;
        components.set(lastChunk.drawIndex, (Object)lastChunk);
    }

    public void setIndirectInfoDirty() {
        this.indirectDirty = true;
    }

    public void setFrameSync(long sync) {
        this.indirectBufferFences[this.currentIndirectBuffer] = sync;
        this.instanceDataFences[this.currentFrame] = sync;
    }

    public int verticesForRenderType(RenderType renderType, boolean shadowsEnabled) {
        if (!this.enabled) {
            return 0;
        }
        if (this.culled && !shadowsEnabled) {
            return 0;
        }
        if (this.isEmpty()) {
            return 0;
        }
        int vertices = this.verticesPerRenderType.getOrDefault((Object)renderType, -1);
        if (vertices == -1) {
            return 0;
        }
        return vertices;
    }

    @Override
    public void drawFeedback(RenderType renderType, boolean shadowsEnabled) {
        if (!this.enabled) {
            return;
        }
        if (this.culled && !shadowsEnabled) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        long offsets = this.drawOffsets[this.currentFrame].getOrDefault((Object)renderType, -1L);
        if (offsets == -1L) {
            return;
        }
        int indirectOffset = (int)(offsets >> 32);
        int draws = (int)offsets;
        GL45C.glBindVertexBuffer((int)1, (int)this.instanceDataBuffer.buffer(3).handle(), (long)0L, (int)128);
        GL45C.glBindBuffer((int)36671, (int)this.indirectBuffers[this.currentIndirectBuffer].activeBuffer().handle());
        GL45C.glMultiDrawArraysIndirect((int)0, (long)indirectOffset, (int)draws, (int)0);
    }
}

