/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.VectorUtil;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.gl33.GL33Buffer;
import net.roguelogix.quartz.internal.gl33.GL33Statics;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL33C;

public class GL33LightEngine {
    private static final int CHUNK_UPDATES_PER_FRAME = 16;
    private static boolean allocsDirty = false;
    private static final Long2ReferenceOpenHashMap<SoftReference<Chunk>> allChunks = new Long2ReferenceOpenHashMap();
    private static final Long2ReferenceOpenHashMap<WeakReference<ChunkHandle>> chunkHandles = new Long2ReferenceOpenHashMap();
    private static final FastArraySet<WeakReference<ChunkHandle>> dirtyChunks = new FastArraySet();
    private static int freeCommitedIndices = 0;
    private static final ObjectArrayList<ShortArrayList> freeIndices = new ObjectArrayList(GL33Statics.LIGHT_TEXTURE_ARRAY_FULL_SIZE.z());
    private static final BooleanArrayList residentLayers;
    private static final int[][] intermediateTextures;
    private static final Vector3i virtualPageSize;
    private static PointerWrapper lookupData;
    private static Vector3i lookupOffset;
    private static GL33Buffer lookupBuffer;
    private static int lookupTexture;
    private static GL33Buffer unpackBuffer;
    private static GL33Buffer.Allocation[] unpackBufferAllocs;

    public static void startup() {
        int i;
        int pageSizeIndex = -1;
        for (i = GL33Statics.LIGHT_TEXTURE_ARRAY_FULL_SIZE.z() - 1; i >= 0; --i) {
            residentLayers.add(false);
        }
        lookupTexture = GL33C.glGenTextures();
        GL33C.glBindTexture((int)35882, (int)lookupTexture);
        GL33C.glTexBuffer((int)35882, (int)33332, (int)lookupBuffer.handle());
        GL33C.glBindTexture((int)35882, (int)0);
        for (i = 0; i < 16; ++i) {
            GL33LightEngine.unpackBufferAllocs[i] = unpackBuffer.alloc(69120, 2);
        }
    }

    public static void shutdown() {
        for (int i = 0; i < intermediateTextures.length; ++i) {
            for (int j = 0; j < intermediateTextures[i].length; ++j) {
                GL33C.glDeleteTextures((int)intermediateTextures[i][j]);
            }
        }
        lookupData.free();
    }

    public static Vector3ic lookupOffset() {
        return lookupOffset;
    }

    public static void bindIndex() {
        GL33C.glActiveTexture((int)33985);
        GL33C.glBindTexture((int)35882, (int)lookupTexture);
        GL33C.glActiveTexture((int)33984);
    }

    public static void unbindIndex() {
        GL33C.glActiveTexture((int)33985);
        GL33C.glBindTexture((int)32879, (int)0);
        GL33C.glActiveTexture((int)33984);
    }

    private static short allocLightChunk() {
        ShortArrayList indices;
        allocsDirty = true;
        for (int i = 0; i < residentLayers.size(); ++i) {
            if (!residentLayers.getBoolean(i) || (indices = (ShortArrayList)freeIndices.get(i)).isEmpty()) continue;
            short index = indices.popShort();
            --freeCommitedIndices;
            index = (short)(index << 10);
            index = (short)(index | i);
            return index;
        }
        for (int layerIndex = 0; layerIndex < residentLayers.size(); ++layerIndex) {
            if (residentLayers.getBoolean(layerIndex)) continue;
            indices = (ShortArrayList)freeIndices.get(layerIndex);
            indices.clear();
            for (short j = 5; j >= 0; j = (short)(j - 1)) {
                indices.add(j);
            }
            int[] layerTextures = intermediateTextures[layerIndex >> 4];
            for (int i = 0; i < layerTextures.length; ++i) {
                layerTextures[i] = GL33C.glGenTextures();
                GL33C.glBindTexture((int)35866, (int)layerTextures[i]);
                GL33C.glTexParameteri((int)35866, (int)10241, (int)9728);
                GL33C.glTexParameteri((int)35866, (int)10240, (int)9728);
                GL33C.glTexImage3D((int)35866, (int)0, (int)33332, (int)GL33Statics.LIGHT_TEXTURE_ARRAY_BLOCK_SIZE.x(), (int)GL33Statics.LIGHT_TEXTURE_ARRAY_BLOCK_SIZE.y(), (int)GL33Statics.LIGHT_TEXTURE_ARRAY_BLOCK_SIZE.z(), (int)0, (int)36244, (int)5121, (long)0L);
            }
            RenderSystem.bindTexture((int)0);
            freeCommitedIndices += 56;
            residentLayers.set(layerIndex, true);
            short index = indices.popShort();
            --freeCommitedIndices;
            index = (short)(index << 10);
            index = (short)(index | layerIndex);
            return index;
        }
        throw new IllegalStateException("Unable to allocate lighting chunk index");
    }

    private static void freeLightChunk(short index) {
        allocsDirty = true;
        int layerIndex = index & 0x3FF;
        short subIndex = (short)(index >> 10 & 0x3F);
        if (!residentLayers.getBoolean(layerIndex)) {
            throw new IllegalArgumentException("Attempt to free lighting chunk index from non-resident layer");
        }
        ShortArrayList indices = (ShortArrayList)freeIndices.get(layerIndex);
        indices.add(subIndex);
        if (freeIndices.size() != 56) {
            return;
        }
        if (freeCommitedIndices <= 1792) {
            return;
        }
        int blockBaseIndex = layerIndex >> 4 << 4;
        for (int j = 0; j < 16; ++j) {
            if (!residentLayers.getBoolean(blockBaseIndex + j)) continue;
            return;
        }
        int[] layerTextures = intermediateTextures[layerIndex >> 4];
        GL33C.glDeleteTextures((int[])layerTextures);
        freeCommitedIndices -= 56;
        residentLayers.set(layerIndex, false);
    }

    public static void update(BlockAndTintGetter blockAndTintGetter) {
        GL33LightEngine.runLightingUpdates(blockAndTintGetter);
        GL33LightEngine.runAllocUpdates();
    }

    public static void runLightingUpdates(BlockAndTintGetter blockAndTintGetter) {
        if (dirtyChunks.isEmpty()) {
            return;
        }
        int updatesThisFrame = 0;
        for (int i = 0; i < dirtyChunks.size(); ++i) {
            WeakReference value = (WeakReference)dirtyChunks.get(i);
            ChunkHandle chunk = (ChunkHandle)value.get();
            if (chunk == null) {
                dirtyChunks.remove((Object)value);
                --i;
                continue;
            }
            chunk.chunk.update(blockAndTintGetter, unpackBufferAllocs[updatesThisFrame]);
            ++updatesThisFrame;
            if (!chunk.chunk.dirty) {
                dirtyChunks.remove((Object)value);
                --i;
            }
            if (updatesThisFrame >= 16) break;
        }
        RenderSystem.bindTexture((int)0);
    }

    public static void runAllocUpdates() {
        long chunkPos;
        if (!allocsDirty) {
            return;
        }
        allocsDirty = false;
        Vector3i tempVec = new Vector3i();
        lookupOffset.set(Integer.MAX_VALUE);
        for (Long2ReferenceMap.Entry chunk : chunkHandles.long2ReferenceEntrySet()) {
            chunkPos = chunk.getLongKey();
            lookupOffset.min((Vector3ic)VectorUtil.fromSectionPos((long)chunkPos, (Vector3i)tempVec));
        }
        lookupData.set((byte)-1);
        for (Long2ReferenceMap.Entry chunkEntry : chunkHandles.long2ReferenceEntrySet()) {
            chunkPos = chunkEntry.getLongKey();
            ChunkHandle chunkHandle = (ChunkHandle)((WeakReference)chunkEntry.getValue()).get();
            if (chunkHandle == null) continue;
            short lookupIndex = chunkHandle.chunk.lightChunkIndex;
            VectorUtil.fromSectionPos((long)chunkPos, (Vector3i)tempVec);
            tempVec.sub((Vector3ic)lookupOffset);
            int texelIndex = 0;
            texelIndex += tempVec.z;
            texelIndex *= 24;
            texelIndex += tempVec.y;
            texelIndex *= 64;
            lookupData.putShortIdx(texelIndex += tempVec.x, lookupIndex);
        }
        GL33C.glBindBuffer((int)36663, (int)lookupBuffer.handle());
        GL33C.nglBufferSubData((int)36663, (long)0L, (long)lookupData.size(), (long)lookupData.pointer());
        GL33C.glBindBuffer((int)36663, (int)0);
    }

    public static void sectionDirty(int x, int y, int z) {
        long pos = SectionPos.m_123209_((int)x, (int)y, (int)z);
        WeakReference weakRef = (WeakReference)chunkHandles.get(pos);
        if (weakRef == null) {
            return;
        }
        ChunkHandle chunk = (ChunkHandle)weakRef.get();
        if (chunk == null) {
            return;
        }
        chunk.chunk.dirty = true;
        dirtyChunks.add((Object)weakRef);
    }

    public static ChunkHandle getChunk(long position) {
        ChunkHandle existingHandle;
        WeakReference existingHandleRef = (WeakReference)chunkHandles.get(position);
        if (existingHandleRef != null && (existingHandle = (ChunkHandle)existingHandleRef.get()) != null) {
            return existingHandle;
        }
        Chunk chunk = GL33LightEngine.getActualChunk(position);
        ChunkHandle handle = new ChunkHandle(chunk);
        WeakReference<ChunkHandle> reference = new WeakReference<ChunkHandle>(handle);
        allocsDirty = true;
        chunkHandles.put(position, reference);
        chunk.dirty = true;
        dirtyChunks.add(reference);
        return handle;
    }

    private static Chunk getActualChunk(long pos) {
        Chunk chunk;
        SoftReference softRef = (SoftReference)allChunks.get(pos);
        if (softRef != null && (chunk = (Chunk)softRef.get()) != null) {
            return chunk;
        }
        Chunk newChunk = new Chunk(pos);
        allChunks.put(pos, new SoftReference<Chunk>(newChunk));
        return newChunk;
    }

    public static int drawForEachLayer(int requiredVertices, int activeLayerLocation, int srcBuffer, int intermediateBuffer, int VAO1, int VAO2) {
        block0: for (int i = 0; i < residentLayers.size(); i += 16) {
            for (int j = 0; j < 16; ++j) {
                if (!residentLayers.getBoolean(i + j)) {
                    continue;
                }
                int[] textures = intermediateTextures[i >> 4];
                for (int j2 = 0; j2 < 6; ++j2) {
                    RenderSystem.activeTexture((int)(33986 + j2));
                    GL33C.glBindTexture((int)35866, (int)textures[j2]);
                }
                GL33C.glUniform1ui((int)activeLayerLocation, (int)i);
                B3DStateHelper.bindVertexArray(VAO1);
                GL33C.glBindBufferBase((int)35982, (int)0, (int)intermediateBuffer);
                GL33C.glBeginTransformFeedback((int)0);
                GL33C.glDrawArrays((int)0, (int)0, (int)requiredVertices);
                GL33C.glEndTransformFeedback();
                intermediateBuffer ^= (srcBuffer ^= intermediateBuffer);
                srcBuffer ^= intermediateBuffer;
                VAO2 ^= (VAO1 ^= VAO2);
                VAO1 ^= VAO2;
                continue block0;
            }
        }
        for (int j = 0; j < 6; ++j) {
            RenderSystem.activeTexture((int)(33986 + j));
            RenderSystem.bindTexture((int)0);
            GL33C.glBindTexture((int)35866, (int)0);
        }
        return srcBuffer;
    }

    static {
        for (int i = 0; i < GL33Statics.LIGHT_TEXTURE_ARRAY_FULL_SIZE.z(); ++i) {
            freeIndices.add((Object)new ShortArrayList(56));
        }
        residentLayers = new BooleanArrayList(GL33Statics.LIGHT_TEXTURE_ARRAY_FULL_SIZE.z());
        intermediateTextures = new int[GL33Statics.LIGHT_TEXTURE_ARRAY_BLOCK_COUNT.z()][6];
        virtualPageSize = new Vector3i();
        lookupData = PointerWrapper.alloc(196608L);
        lookupOffset = new Vector3i();
        lookupBuffer = new GL33Buffer(196608, true);
        unpackBuffer = new GL33Buffer(0x10E000, true);
        unpackBufferAllocs = new GL33Buffer.Allocation[16];
    }

    public static final class ChunkHandle {
        private final Chunk chunk;

        private ChunkHandle(Chunk chunk) {
            this.chunk = chunk;
            long pos = chunk.sectionPos;
            QuartzCore.mainThreadClean(this, () -> {
                allocsDirty = true;
                WeakReference removedRef = (WeakReference)chunkHandles.remove(pos);
                if (removedRef.get() != null) {
                    chunkHandles.put(pos, (Object)removedRef);
                }
            });
        }
    }

    private static class Chunk {
        public final long sectionPos;
        public final short lightChunkIndex;
        private boolean dirty = false;
        private static Vector2f scratchVec = new Vector2f();

        private Chunk(long pos) {
            this.sectionPos = pos;
            short lightChunkIndex = GL33LightEngine.allocLightChunk();
            this.dirty = true;
            long[] lastSync = new long[1];
            QuartzCore.mainThreadClean(this, () -> {
                if (lastSync[0] != 0L) {
                    GL33C.glClientWaitSync((long)lastSync[0], (int)1, (long)0L);
                    GL33C.glDeleteSync((long)lastSync[0]);
                }
                GL33LightEngine.freeLightChunk(lightChunkIndex);
            });
            this.lightChunkIndex = lightChunkIndex;
        }

        private boolean update(BlockAndTintGetter blockAndTintGetter, GL33Buffer.Allocation unpackAlloc) {
            if (!this.dirty) {
                return false;
            }
            this.dirty = false;
            int sectionBaseX = SectionPos.m_123223_((int)SectionPos.m_123213_((long)this.sectionPos));
            int sectionBaseY = SectionPos.m_123223_((int)SectionPos.m_123225_((long)this.sectionPos));
            int sectionBaseZ = SectionPos.m_123223_((int)SectionPos.m_123230_((long)this.sectionPos));
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            PointerWrapper rawData = PointerWrapper.alloc(12288L);
            int index = 0;
            for (int x = -1; x < 17; ++x) {
                for (int y = -1; y < 17; ++y) {
                    for (int z = -1; z < 17; ++z) {
                        int skyLight;
                        int blockLight;
                        int currentX = sectionBaseX + x;
                        int currentY = sectionBaseY + y;
                        int currentZ = sectionBaseZ + z;
                        mutableBlockPos.m_122178_(currentX, currentY, currentZ);
                        BlockState blockState = blockAndTintGetter.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60631_((BlockGetter)blockAndTintGetter, (BlockPos)mutableBlockPos)) {
                            blockLight = -1;
                            skyLight = -1;
                        } else {
                            blockLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)mutableBlockPos);
                            skyLight = blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)mutableBlockPos);
                        }
                        rawData.putByte(index++, (byte)skyLight);
                        rawData.putByte(index++, (byte)blockLight);
                    }
                }
            }
            int lightChunkX = this.lightChunkIndex >> 11 & 0x1F;
            int lightChunkY = this.lightChunkIndex >> 10 & 1;
            int lightChunkZ = this.lightChunkIndex & 0x3FF;
            int lightChunkTexelX = lightChunkX * 18;
            int lightChunkTexelY = lightChunkY * 320;
            int[] lightChunkTextures = intermediateTextures[lightChunkZ >> 4];
            int lightChunkDirectionIndices = 5760;
            int lightChunkDirectionSize = 11520;
            PointerWrapper directionalData = PointerWrapper.alloc(69120L);
            Vector2f[][][] neighborLevels = new Vector2f[2][2][2];
            Vector3i[] outputValues = new Vector3i[6];
            for (int x = 0; x < 17; ++x) {
                for (int y = 0; y < 17; ++y) {
                    for (int z = 0; z < 17; ++z) {
                        int i;
                        for (i = 0; i < 2; ++i) {
                            for (int j = 0; j < 2; ++j) {
                                for (int k = 0; k < 2; ++k) {
                                    int shortIndex = ((x + i) * 18 + (y + j)) * 18 + (z + k);
                                    neighborLevels[i][j][k] = new Vector2f((float)rawData.getByte((long)shortIndex * 2L + 1L), (float)rawData.getByte((long)shortIndex * 2L));
                                }
                            }
                        }
                        outputValues[0] = Chunk.averageValues(neighborLevels[1][0][0], neighborLevels[1][0][1], neighborLevels[1][1][0], neighborLevels[1][1][1]);
                        outputValues[3] = Chunk.averageValues(neighborLevels[0][0][0], neighborLevels[0][0][1], neighborLevels[0][1][0], neighborLevels[0][1][1]);
                        outputValues[1] = Chunk.averageValues(neighborLevels[0][1][0], neighborLevels[0][1][1], neighborLevels[1][1][0], neighborLevels[1][1][1]);
                        outputValues[4] = Chunk.averageValues(neighborLevels[0][0][0], neighborLevels[0][0][1], neighborLevels[1][0][0], neighborLevels[1][0][1]);
                        outputValues[2] = Chunk.averageValues(neighborLevels[0][0][1], neighborLevels[0][1][1], neighborLevels[1][0][1], neighborLevels[1][1][1]);
                        outputValues[5] = Chunk.averageValues(neighborLevels[0][0][0], neighborLevels[0][1][0], neighborLevels[1][0][0], neighborLevels[1][1][0]);
                        for (i = 0; i < 6; ++i) {
                            Vector3i val = outputValues[i];
                            if (val.z == 0) {
                                val = outputValues[(i + 3) % 6];
                            }
                            int bufferIndex = (z * 18 + y) * 18 + x + 5760 * i;
                            directionalData.putShortIdx(bufferIndex, Chunk.packLightAOuint16(val));
                        }
                    }
                }
            }
            GL33C.glBindBuffer((int)35052, (int)unpackAlloc.allocator().handle());
            GL33C.nglBufferSubData((int)35052, (long)unpackAlloc.offset(), (long)Math.min((long)unpackAlloc.size(), directionalData.size()), (long)directionalData.pointer());
            for (int i = 0; i < 6; ++i) {
                int offset = unpackAlloc.offset() + 11520 * i;
                GL33C.glBindTexture((int)35866, (int)lightChunkTextures[i]);
                GL33C.glTexSubImage3D((int)35866, (int)0, (int)lightChunkTexelX, (int)lightChunkTexelY, (int)(lightChunkZ & 0xF), (int)18, (int)320, (int)1, (int)36244, (int)5123, (long)offset);
            }
            GL33C.glBindBuffer((int)35052, (int)0);
            directionalData.free();
            return true;
        }

        private static Vector3i averageValues(Vector2f A, Vector2f B, Vector2f C, Vector2f D) {
            int validLevels = 0;
            Vector2f lightLevel = scratchVec;
            lightLevel.set(0.0f);
            if (A.x() != -1.0f) {
                lightLevel.add((Vector2fc)A);
                ++validLevels;
            }
            if (B.x() != -1.0f) {
                lightLevel.add((Vector2fc)B);
                ++validLevels;
            }
            if (C.x() != -1.0f) {
                lightLevel.add((Vector2fc)C);
                ++validLevels;
            }
            if (D.x() != -1.0f) {
                lightLevel.add((Vector2fc)D);
                ++validLevels;
            }
            if (validLevels != 0) {
                lightLevel.mul(4.0f);
                lightLevel.div((float)validLevels);
            }
            return new Vector3i((int)lightLevel.x, (int)lightLevel.y, 4 - validLevels);
        }

        private static short packLightAOuint16(Vector3i lightAO) {
            short packedInt = 0;
            packedInt = (short)(packedInt | (lightAO.x() & 0x3F) << 6);
            packedInt = (short)(packedInt | lightAO.y() & 0x3F);
            packedInt = (short)(packedInt | (lightAO.z() & 3) << 12);
            return packedInt;
        }

        private static short unpackAO(short packedVal) {
            return (short)(packedVal >> 12 & 3);
        }

        private static short setAO(short val, short newAO) {
            return (short)(val & 0xFFF | (newAO & 3) << 12);
        }
    }
}

