/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.internal.MagicNumbers;
import net.roguelogix.quartz.internal.MultiBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
public class DynamicMatrixManager
implements DynamicMatrix.Manager {
    private final MultiBuffer<?> buffer;
    private final ObjectArrayList<WeakReference<Matrix>> rootMatrices = new ObjectArrayList();

    public DynamicMatrixManager(MultiBuffer<?> buffer) {
        this.buffer = buffer;
    }

    @Override
    public DynamicMatrix createMatrix(@Nullable Matrix4fc initialValue, @Nullable DynamicMatrix.UpdateFunc updateFunc, @Nullable DynamicMatrix parent) {
        Matrix parentMatrix = null;
        if (parent != null) {
            Matrix parentMat;
            if (parent instanceof Matrix && this.owns(parentMat = (Matrix)parent)) {
                parentMatrix = parentMat;
            } else {
                throw new IllegalArgumentException("Parent matrix must be from the same manager");
            }
        }
        ObjectArrayList<WeakReference<Matrix>> list = parentMatrix == null ? this.rootMatrices : ((Matrix)parent).childMatrices;
        return new Matrix(initialValue, this.buffer.alloc(128, 128), updateFunc, list);
    }

    @Override
    public boolean owns(@Nullable DynamicMatrix dynamicMatrix) {
        if (dynamicMatrix instanceof Matrix) {
            Matrix mat = (Matrix)dynamicMatrix;
            return mat.allocation.allocator() == this.buffer;
        }
        return false;
    }

    public void updateAll(long nanos, float partialTicks, Vector3i playerBlock, Vector3f playerPartialBlock) {
        for (int i = 0; i < this.rootMatrices.size(); ++i) {
            Matrix mat = (Matrix)((WeakReference)this.rootMatrices.get(i)).get();
            if (mat == null) continue;
            mat.update(nanos, partialTicks, playerBlock, playerPartialBlock, MagicNumbers.IDENTITY_MATRIX);
        }
        this.buffer.dirtyAll();
    }

    public static class Matrix
    implements DynamicMatrix {
        private final MultiBuffer.Allocation allocation;
        private final Matrix4f localTransformMatrix = new Matrix4f();
        private final Matrix4f transformMatrix = new Matrix4f();
        private final Matrix4f normalMatrix = new Matrix4f();
        private final ObjectArrayList<WeakReference<Matrix>> childMatrices = new ObjectArrayList();
        @Nullable
        private final DynamicMatrix.UpdateFunc updateFunc;
        private boolean deleted = false;

        public Matrix(@Nullable Matrix4fc initialValue, MultiBuffer.Allocation allocation, @Nullable DynamicMatrix.UpdateFunc updateFunc, ObjectArrayList<WeakReference<Matrix>> matrixList) {
            if (initialValue != null) {
                this.localTransformMatrix.set(initialValue);
            }
            this.allocation = allocation;
            this.updateFunc = updateFunc;
            WeakReference<Matrix> ref = new WeakReference<Matrix>(this);
            matrixList.add(ref);
            QuartzCore.mainThreadClean(this, () -> {
                matrixList.remove((Object)ref);
                allocation.free();
            });
        }

        public void update(long nanos, float partialTicks, Vector3i playerBlock, Vector3f playerPartialBlock, Matrix4fc parentTransform) {
            if (this.deleted) {
                return;
            }
            if (this.updateFunc != null) {
                this.updateFunc.accept(this.localTransformMatrix, nanos, partialTicks, (Vector3ic)playerBlock, (Vector3fc)playerPartialBlock);
            }
            this.transformMatrix.set((Matrix4fc)this.localTransformMatrix);
            parentTransform.mul((Matrix4fc)this.transformMatrix, this.transformMatrix);
            this.transformMatrix.normal(this.normalMatrix);
            PointerWrapper buffer = this.allocation.activeAllocation().address();
            buffer.putMatrix4fIdx(0L, (Matrix4fc)this.transformMatrix);
            buffer.putMatrix4fIdx(1L, (Matrix4fc)this.normalMatrix);
            for (int i = 0; i < this.childMatrices.size(); ++i) {
                Matrix mat = (Matrix)((WeakReference)this.childMatrices.get(i)).get();
                if (mat == null || mat.deleted) {
                    WeakReference removed = (WeakReference)this.childMatrices.pop();
                    if (i != this.childMatrices.size()) {
                        this.childMatrices.set(i, (Object)removed);
                    }
                    --i;
                    continue;
                }
                mat.update(nanos, partialTicks, playerBlock, playerPartialBlock, (Matrix4fc)this.transformMatrix);
            }
        }

        public int id(int frame) {
            return this.allocation.allocation(frame).offset() / 128;
        }

        @Override
        public void delete() {
            for (WeakReference value : this.childMatrices) {
                Matrix child = (Matrix)value.get();
                if (child == null || child.deleted) continue;
                throw new IllegalStateException("Cannot delete a dynamic matrix with live children");
            }
            this.deleted = true;
        }
    }
}

