/*
 * Decompiled with CFR 0.152.
 */
package cats.data;

import cats.Align;
import cats.Applicative;
import cats.Show;
import cats.Show$;
import cats.TraverseFilter;
import cats.data.Chain$;
import cats.data.Chain$Append$;
import cats.data.Chain$Empty$;
import cats.data.Chain$Singleton$;
import cats.data.Chain$Wrap$;
import cats.data.ChainCompat;
import cats.data.NonEmptyChainImpl$;
import cats.data.NonEmptyChainOps$;
import cats.kernel.Eq;
import cats.kernel.Hash;
import cats.kernel.Monoid;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.kernel.Semigroup;
import cats.kernel.instances.StaticMethods$;
import cats.package$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public abstract class Chain<A>
implements ChainCompat<A> {
    public static <A> Chain<A> apply(Seq<A> seq) {
        return Chain$.MODULE$.apply(seq);
    }

    public static <A> Eq<Chain<A>> catsDataEqForChain(Eq<A> eq2) {
        return Chain$.MODULE$.catsDataEqForChain(eq2);
    }

    public static <A> Hash<Chain<A>> catsDataHashForChain(Hash<A> hash2) {
        return Chain$.MODULE$.catsDataHashForChain(hash2);
    }

    public static Align<Chain> catsDataInstancesForChain() {
        return Chain$.MODULE$.catsDataInstancesForChain();
    }

    public static <A> Monoid<Chain<A>> catsDataMonoidForChain() {
        return Chain$.MODULE$.catsDataMonoidForChain();
    }

    public static <A> Order<Chain<A>> catsDataOrderForChain(Order<A> order2) {
        return Chain$.MODULE$.catsDataOrderForChain(order2);
    }

    public static <A> PartialOrder<Chain<A>> catsDataPartialOrderForChain(PartialOrder<A> partialOrder2) {
        return Chain$.MODULE$.catsDataPartialOrderForChain(partialOrder2);
    }

    public static <A> Show<Chain<A>> catsDataShowForChain(Show<A> show) {
        return Chain$.MODULE$.catsDataShowForChain(show);
    }

    public static TraverseFilter<Chain> catsDataTraverseFilterForChain() {
        return Chain$.MODULE$.catsDataTraverseFilterForChain();
    }

    public static <A> Chain<A> empty() {
        return Chain$.MODULE$.empty();
    }

    public static <A> Chain<A> fromIterableOnce(IterableOnce<A> iterableOnce) {
        return Chain$.MODULE$.fromIterableOnce((IterableOnce)iterableOnce);
    }

    public static <A> Chain<A> fromOption(Option<A> option) {
        return Chain$.MODULE$.fromOption(option);
    }

    public static <A> Chain<A> fromSeq(Seq<A> seq) {
        return Chain$.MODULE$.fromSeq((Seq)seq);
    }

    public static Chain<Nothing$> nil() {
        return Chain$.MODULE$.nil();
    }

    public static <A> Chain<A> one(A a) {
        return Chain$.MODULE$.one(a);
    }

    public static int ordinal(Chain<?> chain) {
        return Chain$.MODULE$.ordinal(chain);
    }

    public static <G, A, B> Object traverseFilterViaChain(IndexedSeq<A> indexedSeq, Function1<A, Object> function1, Applicative<G> applicative) {
        return Chain$.MODULE$.traverseFilterViaChain(indexedSeq, function1, applicative);
    }

    public static <G, A, B> Object traverseViaChain(IndexedSeq<A> indexedSeq, Function1<A, Object> function1, Applicative<G> applicative) {
        return Chain$.MODULE$.traverseViaChain(indexedSeq, function1, applicative);
    }

    public static <A> Option<Seq<A>> unapplySeq(Chain<A> chain) {
        return Chain$.MODULE$.unapplySeq(chain);
    }

    public final Option<Tuple2<A, Chain<A>>> uncons() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            Chain<Nothing$> rights = null;
            Tuple2 result = null;
            while (result == null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    Chain<Nothing$> next = rights == null ? Chain$.MODULE$.nil() : rights;
                    result = Tuple2$.MODULE$.apply(a2, next);
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty<Nothing$> nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty<Nothing$> r = nonEmpty3;
                    rights = rights == null ? r : Chain$Append$.MODULE$.apply(r, rights);
                    c = l;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    Chain<Nothing$> chain2;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Chain<Nothing$> tail = Chain$.MODULE$.fromSeq((Seq)seq2.tail());
                    if (rights == null) {
                        chain2 = tail;
                    } else {
                        Chain<Nothing$> chain3 = tail;
                        if (chain3 instanceof NonEmpty) {
                            NonEmpty non2 = (NonEmpty)chain3;
                            chain2 = Chain$Append$.MODULE$.apply(non2, rights);
                        } else {
                            chain2 = rights;
                        }
                    }
                    Chain<Nothing$> next = chain2;
                    result = Tuple2$.MODULE$.apply(seq2.head(), next);
                    continue;
                }
                throw new MatchError(nonEmpty);
            }
            return Some$.MODULE$.apply(result);
        }
        return None$.MODULE$;
    }

    public final Option<Tuple2<Chain<A>, A>> initLast() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            Chain<Nothing$> lefts = null;
            Tuple2 result = null;
            while (result == null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    Chain<Nothing$> pre = lefts == null ? Chain$.MODULE$.nil() : lefts;
                    result = Tuple2$.MODULE$.apply(pre, a2);
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty<Nothing$> nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty<Nothing$> l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    lefts = lefts == null ? l : Chain$Append$.MODULE$.apply(lefts, l);
                    c = r;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    Chain<Nothing$> chain2;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Chain<Nothing$> init = Chain$.MODULE$.fromSeq((Seq)seq2.init());
                    if (lefts == null) {
                        chain2 = init;
                    } else {
                        Chain<Nothing$> chain3 = init;
                        if (chain3 instanceof NonEmpty) {
                            NonEmpty non2 = (NonEmpty)chain3;
                            chain2 = Chain$Append$.MODULE$.apply(lefts, non2);
                        } else {
                            chain2 = lefts;
                        }
                    }
                    Chain<Nothing$> pre = chain2;
                    result = Tuple2$.MODULE$.apply(pre, seq2.last());
                    continue;
                }
                throw new MatchError(nonEmpty);
            }
            return Some$.MODULE$.apply(result);
        }
        return None$.MODULE$;
    }

    public Option<A> headOption() {
        return this.uncons().map((Function1<Tuple2, Object> & Serializable)_$1 -> _$1._1());
    }

    public final Option<A> lastOption() {
        return this.initLast().map((Function1<Tuple2, Object> & Serializable)_$2 -> _$2._2());
    }

    public boolean isEmpty() {
        return !(this instanceof NonEmpty);
    }

    public final boolean nonEmpty() {
        return !this.isEmpty();
    }

    private boolean isEmptyOrSingleton() {
        return this.isEmpty() || this instanceof Singleton;
    }

    public final <A2> Chain<A2> concat(Chain<A2> c) {
        return Chain$.MODULE$.concat(this, c);
    }

    public final <A2> Chain<A2> $plus$plus(Chain<A2> c) {
        return this.concat(c);
    }

    public final <A2> Chain<A2> prepend(A2 a) {
        return Chain$.MODULE$.concat(Chain$.MODULE$.one(a), this);
    }

    public final <A2> Chain<A2> $plus$colon(A2 a) {
        return this.prepend(a);
    }

    public final <A2> Chain<A2> append(A2 a) {
        return Chain$.MODULE$.concat(this, Chain$.MODULE$.one(a));
    }

    public final <A2> Chain<A2> $colon$plus(A2 a) {
        return this.append(a);
    }

    public final <B> Chain<B> map(Function1<A, B> f) {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq<A> seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq<A> seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.map(f));
        }
        return Chain$.MODULE$.fromSeq((Seq)this.iterator().map(f).toVector());
    }

    public final <B> Chain<B> flatMap(Function1<A, Chain<B>> f) {
        Chain<Object> result = Chain$.MODULE$.empty();
        Iterator<A> iter = this.iterator();
        while (iter.hasNext()) {
            result = result.$plus$plus(f.apply(iter.next()));
        }
        return result;
    }

    public final <B> B foldLeft(B z, Function2<B, A, B> f) {
        B result = z;
        Iterator<A> iter = this.iterator();
        while (iter.hasNext()) {
            result = f.apply(result, iter.next());
        }
        return result;
    }

    public final Chain<A> takeWhile(Function1<A, Object> p) {
        ObjectRef result = ObjectRef.create(Chain$.MODULE$.empty());
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            boolean pr = BoxesRunTime.unboxToBoolean(p.apply(a));
            if (pr) {
                Chain chain = ((Chain)result$1.elem).$colon$plus(a);
                result$1.elem = chain;
                chain = null;
            }
            return !pr;
        });
        return (Chain)result.elem;
    }

    public final Chain<A> dropWhile(Function1<A, Object> p) {
        return Chain.go$1(p, this);
    }

    public final <B> B foldRight(B z, Function2<A, B, B> f) {
        B result = z;
        Iterator<A> iter = this.reverseIterator();
        while (iter.hasNext()) {
            result = f.apply(iter.next(), result);
        }
        return result;
    }

    public final <B> Chain<B> collect(PartialFunction<A, B> pf) {
        return this.foldLeft(Chain$.MODULE$.nil(), (Function2<Chain, Object, Chain> & Serializable)(acc, a) -> {
            Object x = pf.applyOrElse(a, Chain$.cats$data$Chain$$$sentinel);
            if (x != Chain$.cats$data$Chain$$$sentinel) {
                return acc.$colon$plus(x);
            }
            return acc;
        });
    }

    public final <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
        ObjectRef<None$> result = ObjectRef.create(None$.MODULE$);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            Object x = pf.applyOrElse(a, Chain$.cats$data$Chain$$$sentinel);
            if (x != Chain$.cats$data$Chain$$$sentinel) {
                Some some = Some$.MODULE$.apply(x);
                result$2.elem = some;
                some = null;
                return true;
            }
            return false;
        });
        return (Option)result.elem;
    }

    public final <B> Option<B> collectFirstSome(Function1<A, Option<B>> f) {
        ObjectRef<None$> result = ObjectRef.create(None$.MODULE$);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            Option x = (Option)f.apply(a);
            if (x.isDefined()) {
                Option option = x;
                result$3.elem = option;
                option = null;
                return true;
            }
            return false;
        });
        return (Option)result.elem;
    }

    public final Chain<A> filter(Function1<A, Object> f) {
        return this.collect((PartialFunction)((Object)new Serializable(f){
            private final Function1 f$2;
            {
                this.f$2 = f$27;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                Object a = object;
                return BoxesRunTime.unboxToBoolean(this.f$2.apply(a));
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                Object a = object;
                if (BoxesRunTime.unboxToBoolean(this.f$2.apply(a))) {
                    return a;
                }
                return function1.apply(x);
            }
        }));
    }

    public final Chain<A> filterNot(Function1<A, Object> f) {
        return this.filter((Function1<Object, boolean> & Serializable)a -> !BoxesRunTime.unboxToBoolean(f.apply(a)));
    }

    public final Option<A> find(Function1<A, Object> f) {
        ObjectRef result = ObjectRef.create(Option$.MODULE$.empty());
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean(f.apply(a));
            if (b) {
                Option option = Option$.MODULE$.apply(a);
                result$4.elem = option;
                option = null;
            }
            return b;
        });
        return (Option)result.elem;
    }

    public final boolean exists(Function1<A, Object> f) {
        BooleanRef result = BooleanRef.create(false);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean(f.apply(a));
            if (b) {
                boolean bl;
                result$5.elem = bl = true;
            }
            return b;
        });
        return result.elem;
    }

    public final boolean forall(Function1<A, Object> f) {
        BooleanRef result = BooleanRef.create(true);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean(f.apply(a));
            if (!b) {
                boolean bl;
                result$6.elem = bl = false;
            }
            return !b;
        });
        return result.elem;
    }

    public final <AA> boolean contains(AA a, Eq<AA> A) {
        return this.exists((Function1<Object, boolean> & Serializable)_$3 -> A.eqv(a, _$3));
    }

    public final <B, C> Chain<C> zipWith(Chain<B> other, Function2<A, B, C> f) {
        if (this.isEmpty() || other.isEmpty()) {
            return Chain$Empty$.MODULE$;
        }
        Iterator<A> iterA = this.iterator();
        Iterator<B> iterB = other.iterator();
        Chain<C> result = Chain$.MODULE$.one(f.apply(iterA.next(), iterB.next()));
        while (iterA.hasNext() && iterB.hasNext()) {
            result = result.$colon$plus(f.apply(iterA.next(), iterB.next()));
        }
        return result;
    }

    public final Chain<Tuple2<A, Object>> zipWithIndex() {
        Chain chain;
        Chain chain2 = this;
        if (chain2 instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain2);
            Object a2 = a = singleton._1();
            chain = Chain$Singleton$.MODULE$.apply(Tuple2$.MODULE$.apply(a2, BoxesRunTime.boxToInteger(0)));
        } else if (chain2 instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain2);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            Append a = (Append)chain2;
            chain = Chain$Wrap$.MODULE$.apply(a.iterator().zipWithIndex().toVector());
        } else if (chain2 instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain2);
            Seq seq2 = seq = wrap._1();
            chain = Chain$Wrap$.MODULE$.apply((Seq)seq2.zipWithIndex());
        } else {
            chain = Chain$Empty$.MODULE$;
        }
        return chain;
    }

    public final <B> SortedMap<B, Object> groupBy(Function1<A, B> f, Order<B> B) {
        return this.groupMap(f, (Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x), B);
    }

    public final <K, B> SortedMap<K, Object> groupMap(Function1<A, K> key, Function1<A, B> f, Order<K> K) {
        Ordering<K> ordering = K.toOrdering();
        ObjectRef<SortedMap> m = ObjectRef.create((SortedMap)SortedMap$.MODULE$.empty(ordering));
        this.iterator().foreach(elem -> {
            Object k = key.apply(elem);
            Option option = ((SortedMap)m$1.elem).get(k);
            if (option instanceof Some) {
                Object cat = ((Some)option).value();
                Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(cat);
                SortedMap sortedMap = (SortedMap)((SortedMap)m$1.elem).updated(k, NonEmptyChainOps$.MODULE$.$colon$plus$extension(object, f.apply(elem)));
                m$1.elem = sortedMap;
                sortedMap = null;
                return;
            }
            if (None$.MODULE$.equals(option)) {
                Object r = Predef$.MODULE$.ArrowAssoc(k);
                SortedMap sortedMap = (SortedMap)((SortedMap)m$1.elem).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(r, cats.data.package$.MODULE$.NonEmptyChain().one(f.apply(elem))));
                m$1.elem = sortedMap;
                sortedMap = null;
                return;
            }
            throw new MatchError(option);
        });
        return (SortedMap)m.elem;
    }

    public final <K, B> SortedMap<K, B> groupMapReduce(Function1<A, K> key, Function1<A, B> f, Order<K> K, Semigroup<B> S) {
        return this.groupMapReduceWith(key, f, (Function2<Object, Object, Object> & Serializable)(x, y) -> S.combine(x, y), K);
    }

    public final <K, B> SortedMap<K, B> groupMapReduceWith(Function1<A, K> key, Function1<A, B> f, Function2<B, B, B> combine, Order<K> K) {
        Ordering<K> ordering = K.toOrdering();
        ObjectRef<SortedMap> m = ObjectRef.create((SortedMap)SortedMap$.MODULE$.empty(ordering));
        this.iterator().foreach(elem -> {
            Object k = key.apply(elem);
            Option option = ((SortedMap)m$2.elem).get(k);
            if (option instanceof Some) {
                Object b = ((Some)option).value();
                SortedMap sortedMap = (SortedMap)((SortedMap)m$2.elem).updated(k, combine.apply(b, f.apply(elem)));
                m$2.elem = sortedMap;
                sortedMap = null;
                return;
            }
            if (None$.MODULE$.equals(option)) {
                Object r = Predef$.MODULE$.ArrowAssoc(k);
                SortedMap sortedMap = (SortedMap)((SortedMap)m$2.elem).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(r, f.apply(elem)));
                m$2.elem = sortedMap;
                sortedMap = null;
                return;
            }
            throw new MatchError(option);
        });
        return (SortedMap)m.elem;
    }

    public Chain<A> reverse() {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            NonEmpty l = nonEmpty;
            NonEmpty r = nonEmpty2;
            return Chain.loop$1(l, scala.package$.MODULE$.Nil().$colon$colon(r), Chain$Empty$.MODULE$);
        }
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.reverse());
        }
        return this;
    }

    public final Option<Tuple2<A, Chain<A>>> deleteFirst(Function1<A, Object> f) {
        return Chain.go$2(f, this, Chain$.MODULE$.nil());
    }

    private final void foreachUntil(Function1<A, Object> f) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            List rights = scala.package$.MODULE$.Nil();
            while (c != null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    Object a2 = a;
                    boolean b = BoxesRunTime.unboxToBoolean(f.apply(a2));
                    if (b) {
                        return;
                    }
                    if (rights.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)rights.head();
                        rights = (List)rights.tail();
                        nonEmpty2 = head;
                    }
                    c = nonEmpty2;
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty3 = append._1();
                    NonEmpty nonEmpty4 = append._2();
                    NonEmpty l = nonEmpty3;
                    NonEmpty r = nonEmpty4;
                    rights = rights.$colon$colon(r);
                    c = l;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    NonEmpty nonEmpty5;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Iterator iterator = seq2.iterator();
                    while (iterator.hasNext()) {
                        boolean b = BoxesRunTime.unboxToBoolean(f.apply(iterator.next()));
                        if (!b) continue;
                        return;
                    }
                    if (rights.isEmpty()) {
                        nonEmpty5 = null;
                    } else {
                        NonEmpty head = (NonEmpty)rights.head();
                        rights = (List)rights.tail();
                        nonEmpty5 = head;
                    }
                    c = nonEmpty5;
                    continue;
                }
                throw new MatchError(nonEmpty);
            }
            return;
        }
    }

    public final Iterator<A> iterator() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.iterator();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Iterator().single(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app);
        }
        return scala.package$.MODULE$.Iterator().empty();
    }

    public final Iterator<A> reverseIterator() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.reverseIterator();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Iterator().single(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainReverseIterator(app);
        }
        return scala.package$.MODULE$.Iterator().empty();
    }

    public final long length() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            return Chain.loop$2(ne, scala.package$.MODULE$.Nil(), 0L);
        }
        return 0L;
    }

    public final long size() {
        return this.length();
    }

    public final int lengthCompare(long len) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            return Chain.loop$3(ne, scala.package$.MODULE$.Nil(), len);
        }
        return Long.compare(0L, len);
    }

    public final int sizeCompare(long size) {
        return this.lengthCompare(size);
    }

    public final List<A> toList() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.toList();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Nil().$colon$colon(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app).toList();
        }
        return scala.package$.MODULE$.Nil();
    }

    public final Vector<A> toVector() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.toVector();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return (Vector)((AbstractSeq)scala.package$.MODULE$.Vector().empty()).$colon$plus(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app).toVector();
        }
        return scala.package$.MODULE$.Vector().empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <AA> boolean $eq$eq$eq(Chain<AA> that, Eq<AA> A) {
        if (this == that) return true;
        Iterator<A> iterX = this.iterator();
        Iterator<AA> iterY = that.iterator();
        while (iterX.hasNext() && iterY.hasNext()) {
            if (A.eqv(iterX.next(), iterY.next())) continue;
            return false;
        }
        if (iterX.hasNext() != iterY.hasNext()) return false;
        return true;
    }

    public <AA> Chain<AA> distinct(Order<AA> O2) {
        if (this.isEmptyOrSingleton()) {
            return this;
        }
        Ordering<AA> ord = O2.toOrdering();
        Builder bldr = scala.package$.MODULE$.Vector().newBuilder();
        TreeSet<AA> seen = TreeSet$.MODULE$.empty(ord);
        Iterator<A> it = this.iterator();
        while (it.hasNext()) {
            A next = it.next();
            if (!seen.add(next)) continue;
            bldr.$plus$eq(next);
        }
        return Chain$.MODULE$.fromSeq((Seq)bldr.result());
    }

    public <B> Chain<A> distinctBy(Function1<A, B> f, Order<B> O2) {
        if (this.isEmptyOrSingleton()) {
            return this;
        }
        Ordering<B> ord = O2.toOrdering();
        Builder bldr = scala.package$.MODULE$.Vector().newBuilder();
        TreeSet<B> seen = TreeSet$.MODULE$.empty(ord);
        Iterator<A> it = this.iterator();
        while (it.hasNext()) {
            A next = it.next();
            if (!seen.add(f.apply(next))) continue;
            bldr.$plus$eq(next);
        }
        return Chain$.MODULE$.fromSeq((Seq)bldr.result());
    }

    public <AA> String show(Show<AA> AA) {
        StringBuilder builder = new StringBuilder("Chain(");
        BooleanRef first = BooleanRef.create(true);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            Serializable serializable;
            if (first$1.elem) {
                boolean bl;
                builder.$plus$plus$eq(AA.show(a));
                first$1.elem = bl = false;
                serializable = BoxedUnit.UNIT;
            } else {
                serializable = builder.$plus$plus$eq(new java.lang.StringBuilder(2).append(", ").append(AA.show(a)).toString());
            }
            return false;
        });
        builder.$plus$eq(BoxesRunTime.boxToCharacter(')'));
        return builder.result();
    }

    public <AA> int hash(Hash<AA> hashA) {
        return StaticMethods$.MODULE$.orderedHash(this.iterator(), hashA);
    }

    public String toString() {
        return this.show(Show$.MODULE$.fromToString());
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Chain) {
            Chain thatChain = (Chain)object;
            return this.$eq$eq$eq(thatChain, package$.MODULE$.Eq().fromUniversalEquals());
        }
        return false;
    }

    public int hashCode() {
        return this.hash(package$.MODULE$.Hash().fromUniversalHashCode());
    }

    public final Option<A> get(long idx) {
        if (idx < 0L) {
            return None$.MODULE$;
        }
        ObjectRef<None$> result = ObjectRef.create(None$.MODULE$);
        LongRef i = LongRef.create(0L);
        this.foreachUntil((Function1<Object, boolean> & Serializable)a -> {
            long l;
            if (idx == i$1.elem) {
                Some some = Some$.MODULE$.apply(a);
                result$7.elem = some;
                some = null;
                return true;
            }
            i$1.elem = l = i$1.elem + 1L;
            return false;
        });
        return (Option)result.elem;
    }

    public final <B> Chain<A> sortBy(Function1<A, B> f, Order<B> B) {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            return Chain$Wrap$.MODULE$.apply((Seq)this.toVector().sortBy((Function1)f, (Ordering)B.toOrdering()));
        }
        if (chain instanceof Wrap) {
            Seq<A> seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq<A> seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.sortBy(f, B.toOrdering()));
        }
        return this;
    }

    public final <AA> Chain<AA> sorted(Order<AA> AA) {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            return Chain$Wrap$.MODULE$.apply((Seq)this.toVector().sorted(AA.toOrdering()));
        }
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.sorted(AA.toOrdering()));
        }
        return this;
    }

    private static final Chain go$1(Function1 p$2, Chain rem) {
        Tuple2 tuple2;
        Option option;
        while ((option = rem.uncons()) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object a = tuple2._1();
            Chain tail = (Chain)tuple2._2();
            if (BoxesRunTime.unboxToBoolean(p$2.apply(a))) {
                rem = tail;
                continue;
            }
            return rem;
        }
        if (None$.MODULE$.equals(option)) {
            return Chain$.MODULE$.nil();
        }
        throw new MatchError(option);
    }

    private static final Chain loop$1(NonEmpty h, List tail, Chain acc) {
        NonEmpty nonEmpty;
        block4: {
            Chain nextAcc;
            while (true) {
                Seq seq;
                if ((nonEmpty = h) instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    h = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    Singleton sing = (Singleton)nonEmpty;
                    Chain nextAcc2 = sing.concat(acc);
                    List list = tail;
                    if (list instanceof $colon$colon) {
                        $colon$colon $colon$colon = ($colon$colon)list;
                        List list2 = $colon$colon.next$access$1();
                        NonEmpty h1 = (NonEmpty)$colon$colon.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        Chain chain = nextAcc2;
                        h = nonEmpty5;
                        tail = list3;
                        acc = chain;
                        continue;
                    }
                    return nextAcc2;
                }
                if (!(nonEmpty instanceof Wrap)) break block4;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                nextAcc = Chain$Wrap$.MODULE$.apply((Seq)seq2.reverse()).concat(acc);
                List list = tail;
                if (!(list instanceof $colon$colon)) break;
                $colon$colon $colon$colon = ($colon$colon)list;
                List list4 = $colon$colon.next$access$1();
                NonEmpty h1 = (NonEmpty)$colon$colon.head();
                List t1 = list4;
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                Chain chain = nextAcc;
                h = nonEmpty6;
                tail = list5;
                acc = chain;
            }
            return nextAcc;
        }
        throw new MatchError(nonEmpty);
    }

    private static final Option go$2(Function1 f$9, Chain rem, Chain acc) {
        Tuple2 tuple2;
        Option option;
        while ((option = rem.uncons()) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object a = tuple2._1();
            Chain tail = (Chain)tuple2._2();
            if (!BoxesRunTime.unboxToBoolean(f$9.apply(a))) {
                Chain chain = tail;
                Chain chain2 = acc.$colon$plus(a);
                rem = chain;
                acc = chain2;
                continue;
            }
            return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(a, acc.$plus$plus(tail)));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private static final long loop$2(NonEmpty head, List tail, long acc) {
        NonEmpty nonEmpty;
        block4: {
            long nextAcc;
            while (true) {
                Seq seq;
                if ((nonEmpty = head) instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    head = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    long nextAcc2 = acc + 1L;
                    List list = tail;
                    if (list instanceof $colon$colon) {
                        $colon$colon $colon$colon = ($colon$colon)list;
                        List list2 = $colon$colon.next$access$1();
                        NonEmpty h1 = (NonEmpty)$colon$colon.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        long l = nextAcc2;
                        head = nonEmpty5;
                        tail = list3;
                        acc = l;
                        continue;
                    }
                    return nextAcc2;
                }
                if (!(nonEmpty instanceof Wrap)) break block4;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                nextAcc = acc + (long)seq2.length();
                List list = tail;
                if (!(list instanceof $colon$colon)) break;
                $colon$colon $colon$colon = ($colon$colon)list;
                List list4 = $colon$colon.next$access$1();
                NonEmpty h1 = (NonEmpty)$colon$colon.head();
                List t1 = list4;
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                long l = nextAcc;
                head = nonEmpty6;
                tail = list5;
                acc = l;
            }
            return nextAcc;
        }
        throw new MatchError(nonEmpty);
    }

    private static final int loop$3(NonEmpty head, List tail, long len) {
        NonEmpty nonEmpty;
        block6: {
            int c;
            while (true) {
                Seq seq;
                if (len <= 0L) {
                    return 1;
                }
                nonEmpty = head;
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    head = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    List list = tail;
                    if (list instanceof $colon$colon) {
                        $colon$colon $colon$colon = ($colon$colon)list;
                        List list2 = $colon$colon.next$access$1();
                        NonEmpty h1 = (NonEmpty)$colon$colon.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        long l = len - 1L;
                        head = nonEmpty5;
                        tail = list3;
                        len = l;
                        continue;
                    }
                    return Long.compare(1L, len);
                }
                if (!(nonEmpty instanceof Wrap)) break block6;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                c = len <= Integer.MAX_VALUE ? seq2.lengthCompare((int)len) : -1;
                List list = tail;
                if (!(list instanceof $colon$colon)) break;
                $colon$colon $colon$colon = ($colon$colon)list;
                List list4 = $colon$colon.next$access$1();
                NonEmpty h1 = (NonEmpty)$colon$colon.head();
                List t1 = list4;
                if (c >= 0) {
                    return 1;
                }
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                long l = len - (long)seq2.length();
                head = nonEmpty6;
                tail = list5;
                len = l;
            }
            return c;
        }
        throw new MatchError(nonEmpty);
    }

    public static final class Append<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final NonEmpty leftNE;
        private final NonEmpty rightNE;

        public static <A> Append<A> apply(Chain<A> chain, Chain<A> chain2) {
            return Chain$Append$.MODULE$.apply(chain, chain2);
        }

        public static <A> Append<A> apply(NonEmpty<A> nonEmpty, NonEmpty<A> nonEmpty2) {
            return Chain$Append$.MODULE$.apply(nonEmpty, nonEmpty2);
        }

        public static Append<?> fromProduct(Product product) {
            return Chain$Append$.MODULE$.fromProduct(product);
        }

        public static <A> Append<A> unapply(Append<A> append) {
            return Chain$Append$.MODULE$.unapply(append);
        }

        public Append(NonEmpty<A> leftNE, NonEmpty<A> rightNE) {
            this.leftNE = leftNE;
            this.rightNE = rightNE;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Append;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Append";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "leftNE";
            }
            if (1 == n2) {
                return "rightNE";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public NonEmpty<A> leftNE() {
            return this.leftNE;
        }

        public NonEmpty<A> rightNE() {
            return this.rightNE;
        }

        public Append(Chain<A> left, Chain<A> right) {
            this((NonEmpty)left, (NonEmpty)right);
        }

        public Chain<A> left() {
            return this.leftNE();
        }

        public Chain<A> right() {
            return this.rightNE();
        }

        public Append<A> copy(Chain<A> left, Chain<A> right) {
            return new Append<A>(left, right);
        }

        public Chain<A> copy$default$1() {
            return this.left();
        }

        public Chain<A> copy$default$2() {
            return this.right();
        }

        public <A> Append<A> copy(NonEmpty<A> leftNE, NonEmpty<A> rightNE) {
            return new Append<A>(leftNE, rightNE);
        }

        public <A> NonEmpty<A> copy$default$1() {
            return this.leftNE();
        }

        public <A> NonEmpty<A> copy$default$2() {
            return this.rightNE();
        }

        public NonEmpty<A> _1() {
            return this.leftNE();
        }

        public NonEmpty<A> _2() {
            return this.rightNE();
        }
    }

    public static class ChainIterator<A>
    implements Iterator<A> {
        private NonEmpty<A> c;
        private List<NonEmpty<A>> rights;
        private Iterator<A> currentIterator;

        public ChainIterator(NonEmpty<A> self) {
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            this.c = self;
            this.rights = scala.package$.MODULE$.Nil();
            this.currentIterator = null;
        }

        public ChainIterator(Chain<A> chain) {
            NonEmpty non;
            Chain<A> chain2 = chain;
            this(chain2 instanceof NonEmpty ? (non = (NonEmpty)chain2) : null);
        }

        @Override
        public boolean hasNext() {
            return this.c != null || this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public A next() {
            return (A)this.go$3();
        }

        private final Object go$3() {
            NonEmpty<A> nonEmpty;
            while (true) {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = null;
                nonEmpty = this.c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    if (this.rights.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)this.rights.head();
                        this.rights = (List)this.rights.tail();
                        nonEmpty2 = head;
                    }
                    this.c = nonEmpty2;
                    return a2;
                }
                if (!(nonEmpty instanceof Append)) break;
                Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                NonEmpty nonEmpty3 = append._1();
                NonEmpty nonEmpty4 = append._2();
                NonEmpty l = nonEmpty3;
                NonEmpty r = nonEmpty4;
                this.c = l;
                this.rights = this.rights.$colon$colon(r);
            }
            if (nonEmpty instanceof Wrap) {
                NonEmpty nonEmpty5;
                Seq seq;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                if (this.rights.isEmpty()) {
                    nonEmpty5 = null;
                } else {
                    NonEmpty head = (NonEmpty)this.rights.head();
                    this.rights = (List)this.rights.tail();
                    nonEmpty5 = head;
                }
                this.c = nonEmpty5;
                this.currentIterator = seq2.iterator();
                return this.currentIterator.next();
            }
            if (nonEmpty == null) {
                throw new NoSuchElementException("next called on empty iterator");
            }
            throw new MatchError(nonEmpty);
        }
    }

    public static class ChainReverseIterator<A>
    implements Iterator<A> {
        private NonEmpty<A> c;
        private List<NonEmpty<A>> lefts;
        private Iterator<A> currentIterator;

        public ChainReverseIterator(NonEmpty<A> self) {
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            this.c = self;
            this.lefts = scala.package$.MODULE$.Nil();
            this.currentIterator = null;
        }

        public ChainReverseIterator(Chain<A> chain) {
            NonEmpty non;
            Chain<A> chain2 = chain;
            this(chain2 instanceof NonEmpty ? (non = (NonEmpty)chain2) : null);
        }

        @Override
        public boolean hasNext() {
            return this.c != null || this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public A next() {
            return (A)this.go$4();
        }

        private final Object go$4() {
            NonEmpty<A> nonEmpty;
            while (true) {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = null;
                nonEmpty = this.c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    if (this.lefts.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)this.lefts.head();
                        this.lefts = (List)this.lefts.tail();
                        nonEmpty2 = head;
                    }
                    this.c = nonEmpty2;
                    return a2;
                }
                if (!(nonEmpty instanceof Append)) break;
                Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                NonEmpty nonEmpty3 = append._1();
                NonEmpty nonEmpty4 = append._2();
                NonEmpty l = nonEmpty3;
                NonEmpty r = nonEmpty4;
                this.c = r;
                this.lefts = this.lefts.$colon$colon(l);
            }
            if (nonEmpty instanceof Wrap) {
                NonEmpty nonEmpty5;
                Seq seq;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                if (this.lefts.isEmpty()) {
                    nonEmpty5 = null;
                } else {
                    NonEmpty head = (NonEmpty)this.lefts.head();
                    this.lefts = (List)this.lefts.tail();
                    nonEmpty5 = head;
                }
                this.c = nonEmpty5;
                this.currentIterator = seq2.reverseIterator();
                return this.currentIterator.next();
            }
            if (nonEmpty == null) {
                throw new NoSuchElementException("next called on empty iterator");
            }
            throw new MatchError(nonEmpty);
        }
    }

    public static abstract class NonEmpty<A>
    extends Chain<A> {
    }

    public static final class Singleton<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final Object a;

        public static <A> Singleton<A> apply(A a) {
            return Chain$Singleton$.MODULE$.apply(a);
        }

        public static Singleton<?> fromProduct(Product product) {
            return Chain$Singleton$.MODULE$.fromProduct(product);
        }

        public static <A> Singleton<A> unapply(Singleton<A> singleton) {
            return Chain$Singleton$.MODULE$.unapply(singleton);
        }

        public Singleton(A a) {
            this.a = a;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Singleton;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Singleton";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "a";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A a() {
            return (A)this.a;
        }

        public <A> Singleton<A> copy(A a) {
            return new Singleton<A>(a);
        }

        public <A> A copy$default$1() {
            return this.a();
        }

        public A _1() {
            return this.a();
        }
    }

    public static final class Wrap<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final Seq seq;

        public static <A> Wrap<A> apply(Seq<A> seq) {
            return Chain$Wrap$.MODULE$.apply(seq);
        }

        public static Wrap<?> fromProduct(Product product) {
            return Chain$Wrap$.MODULE$.fromProduct(product);
        }

        public static <A> Wrap<A> unapply(Wrap<A> wrap) {
            return Chain$Wrap$.MODULE$.unapply(wrap);
        }

        public Wrap(Seq<A> seq) {
            this.seq = seq;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Wrap;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Wrap";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "seq";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Seq<A> seq() {
            return this.seq;
        }

        public <A> Wrap<A> copy(Seq<A> seq) {
            return new Wrap<A>(seq);
        }

        public <A> Seq<A> copy$default$1() {
            return this.seq();
        }

        public Seq<A> _1() {
            return this.seq();
        }
    }
}

