/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import me.flashyreese.mods.sodiumextra.client.ClientTickHandler;
import me.flashyreese.mods.sodiumextra.client.SodiumExtraClientMod;
import me.flashyreese.mods.sodiumextra.client.gui.SodiumExtraGameOptions;
import me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="embeddium_extra")
public class SodiumExtraHud {
    private static final List<Component> TEXT_LIST = new ObjectArrayList();
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    @SubscribeEvent
    public static void onStartTick(TickEvent.ClientTickEvent client) {
        MutableComponent text;
        if (client.phase == TickEvent.Phase.END) {
            return;
        }
        TEXT_LIST.clear();
        if (SodiumExtraClientMod.options().extraSettings.showFps) {
            int currentFPS = MinecraftClientAccessor.getCurrentFPS();
            text = Component.m_237110_((String)"sodium-extra.overlay.fps", (Object[])new Object[]{currentFPS});
            if (SodiumExtraClientMod.options().extraSettings.showFPSExtended) {
                text = Component.m_237113_((String)String.format("%s %s", text.getString(), Component.m_237110_((String)"sodium-extra.overlay.fps_extended", (Object[])new Object[]{ClientTickHandler.getHighestFps(), ClientTickHandler.getAverageFps(), ClientTickHandler.getLowestFps()}).getString()));
            }
            TEXT_LIST.add((Component)text);
        }
        if (SodiumExtraClientMod.options().extraSettings.showCoords && !CLIENT.m_91299_() && SodiumExtraHud.CLIENT.f_91074_ != null) {
            Vec3 pos = SodiumExtraHud.CLIENT.f_91074_.m_20182_();
            text = Component.m_237110_((String)"sodium-extra.overlay.coordinates", (Object[])new Object[]{String.format("%.2f", pos.f_82479_), String.format("%.2f", pos.f_82480_), String.format("%.2f", pos.f_82481_)});
            TEXT_LIST.add((Component)text);
        }
        if (!SodiumExtraClientMod.options().renderSettings.lightUpdates) {
            MutableComponent text2 = Component.m_237115_((String)"sodium-extra.overlay.light_updates");
            TEXT_LIST.add((Component)text2);
        }
    }

    @SubscribeEvent
    public static void onHudRender(RenderGuiEvent.Post event) {
        if (!SodiumExtraHud.CLIENT.f_91066_.f_92063_) {
            int n;
            SodiumExtraGameOptions.OverlayCorner overlayCorner = SodiumExtraClientMod.options().extraSettings.overlayCorner;
            if (overlayCorner == SodiumExtraGameOptions.OverlayCorner.BOTTOM_LEFT || overlayCorner == SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT) {
                int n2 = CLIENT.m_91268_().m_85446_();
                Objects.requireNonNull(SodiumExtraHud.CLIENT.f_91062_);
                n = n2 - 9 - 2;
            } else {
                n = 2;
            }
            int y = n;
            for (Component text : TEXT_LIST) {
                int x = overlayCorner == SodiumExtraGameOptions.OverlayCorner.TOP_RIGHT || overlayCorner == SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT ? CLIENT.m_91268_().m_85445_() - SodiumExtraHud.CLIENT.f_91062_.m_92852_((FormattedText)text) - 2 : 2;
                SodiumExtraHud.drawString(event.getGuiGraphics(), text, x, y);
                if (overlayCorner == SodiumExtraGameOptions.OverlayCorner.BOTTOM_LEFT || overlayCorner == SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT) {
                    Objects.requireNonNull(SodiumExtraHud.CLIENT.f_91062_);
                    y -= 9 + 2;
                    continue;
                }
                Objects.requireNonNull(SodiumExtraHud.CLIENT.f_91062_);
                y += 9 + 2;
            }
        }
    }

    private static void drawString(GuiGraphics drawContext, Component text, int x, int y) {
        int textColor = -1;
        if (SodiumExtraClientMod.options().extraSettings.textContrast == SodiumExtraGameOptions.TextContrast.BACKGROUND) {
            int n = x + SodiumExtraHud.CLIENT.f_91062_.m_92852_((FormattedText)text) + 1;
            Objects.requireNonNull(SodiumExtraHud.CLIENT.f_91062_);
            drawContext.m_280509_(x - 1, y - 1, n, y + 9 + 1, -1873784752);
        }
        drawContext.m_280614_(SodiumExtraHud.CLIENT.f_91062_, text, x, y, textColor, SodiumExtraClientMod.options().extraSettings.textContrast == SodiumExtraGameOptions.TextContrast.SHADOW);
    }
}

