/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BaseBlock
extends Block {
    private final boolean saveTileData;

    public BaseBlock(boolean saveTileData, BlockBehaviour.Properties properties) {
        super(properties);
        this.saveTileData = saveTileData;
    }

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        this(saveTileData, properties.toUnderlying());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag compoundTag = tag == null ? null : (tag = tag.m_128441_("tileData") ? tag.m_128469_("tileData") : null);
        if (tag == null || tag.m_128456_()) {
            return;
        }
        BlockEntity entity = worldIn.m_7702_(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(tag);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List items = super.m_49635_(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        BlockEntity entity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (!(entity instanceof BaseBlockEntity)) {
            return items;
        }
        CompoundTag entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.m_128456_()) {
            return items;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tileData", (Tag)entityTag);
        for (ItemStack stack : items) {
            if (!(stack.m_41720_() instanceof BlockItem) || ((BlockItem)stack.m_41720_()).m_40614_() != this) continue;
            stack.m_41751_(tag);
        }
        return items;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        CompoundTag entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.m_128456_()) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tileData", (Tag)entityTag);
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() == this) {
            stack.m_41751_(tag);
        }
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.interact((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (Direction)hitResult.m_82434_(), (Vec3)hitResult.m_82450_()).interactionResult;
    }

    protected InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> information, TooltipFlag flag) {
        this.appendItemInformation(stack, level, information::add, flag.m_7050_());
        super.m_5871_(stack, level, information, flag);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
    }

    public Item m_5456_() {
        return super.m_5456_();
    }

    public String m_7705_() {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(this);
        return identifier.m_135827_() + ".block." + identifier.m_135815_();
    }

    protected static enum InteractionFeedback {
        PASS(InteractionResult.PASS),
        CONSUME(InteractionResult.CONSUME),
        SUCCESS(InteractionResult.SUCCESS);

        private final InteractionResult interactionResult;

        private InteractionFeedback(InteractionResult interactionResult) {
            this.interactionResult = interactionResult;
        }
    }
}

