/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class FarmlandCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    public static final List<FarmlandCrop> FARMLAND_CROPS = new ArrayList<FarmlandCrop>();
    private final String name;
    private final String dropName;
    private final boolean plural;
    private final TagCategory tagCategory;
    private final FoodConstructor registry;
    private Item cropItem;
    private Block cropBlock;
    private Item seedItem;
    private final TagKey<Biome> biomes;

    public FarmlandCrop(String cropName, boolean isPlural, TagCategory category, FoodConstructor registry, TagKey<Biome> biomes) {
        this(cropName, cropName, isPlural, category, registry, biomes);
    }

    public FarmlandCrop(String cropName, String dropName, boolean isPlural, TagCategory category, FoodConstructor registry, TagKey<Biome> biomes) {
        Objects.requireNonNull(category);
        Content.BLOCK_REGISTER.reg(this::registerBlock);
        Content.ITEM_REGISTER.reg(this::registerItem);
        this.name = cropName;
        this.dropName = dropName;
        this.plural = isPlural;
        this.tagCategory = category;
        this.biomes = biomes;
        this.registry = registry;
        FARMLAND_CROPS.add(this);
    }

    @Override
    public Block asBlock() {
        return this.cropBlock;
    }

    @Override
    public String name() {
        return this.dropName;
    }

    @Override
    public boolean hasPlural() {
        return this.plural;
    }

    public Item m_5456_() {
        return this.cropItem;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public Item getSeedItem() {
        return this.seedItem;
    }

    public static List<FarmlandCrop> copy() {
        return FARMLAND_CROPS;
    }

    public void registerBlock(RegisterFunction<Block> register) {
        this.cropBlock = register.register(CroptopiaMod.createIdentifier(this.name + "_crop"), () -> new CroptopiaCropBlock(CroptopiaMod.createCropSettings()));
        CroptopiaMod.cropBlocks.add(this.asBlock());
    }

    public void registerItem(RegisterFunction<Item> register) {
        this.cropItem = register.register(CroptopiaMod.createIdentifier(this.dropName), () -> {
            if (this.registry == null) {
                return new CropItem(CroptopiaMod.createGroup());
            }
            return new CropItem(CroptopiaMod.createGroup().m_41489_(FoodConstructor.createFood(this.registry)));
        });
        this.seedItem = this.name().equals("vanilla") ? register.register(CroptopiaMod.createIdentifier(this.name + "_seeds"), () -> new SeedItem(this.cropBlock, CroptopiaMod.createGroup(), this.biomes)) : register.register(CroptopiaMod.createIdentifier(this.name + "_seed"), () -> new SeedItem(this.cropBlock, CroptopiaMod.createGroup(), this.biomes));
        CroptopiaMod.cropItems.add(this.m_5456_());
        CroptopiaMod.seeds.add(this.seedItem);
    }
}

