/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SlurryHelper {
    @Nonnull
    public static Optional<ISlurryHandler> handler(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.SLURRY_HANDLER != null && provider.getCapability(Capabilities.SLURRY_HANDLER, direction).isPresent()) {
            return Optional.of((ISlurryHandler)provider.getCapability(Capabilities.SLURRY_HANDLER, direction).orElseThrow(() -> new IllegalArgumentException("ISlurryHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof ISlurryHandler.ISidedSlurryHandler && ((ISlurryHandler.ISidedSlurryHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((ISlurryHandler)provider);
        }
        if (!(provider instanceof ISlurryHandler.ISidedSlurryHandler) && provider instanceof ISlurryHandler && ((ISlurryHandler)provider).getTanks() >= 1) {
            return Optional.of((ISlurryHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static SlurryStack insert(ISlurryHandler handler, SlurryStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            return (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (SlurryStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static SlurryStack extract(ISlurryHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            return (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).extractChemical(amount, direction, action);
        }
        return (SlurryStack)handler.extractChemical(amount, action);
    }

    public static List<Slurry> chemicalInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction) {
        ArrayList<Slurry> slurries = new ArrayList<Slurry>();
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            for (int i = 0; i < ((ISlurryHandler.ISidedSlurryHandler)handler).getTanks(direction); ++i) {
                Slurry slurry = (Slurry)((SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).getChemicalInTank(i, direction)).getType();
                if (slurry.isEmptyType()) continue;
                slurries.add(slurry);
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                Slurry slurry = (Slurry)((SlurryStack)handler.getChemicalInTank(i)).getType();
                if (slurry.isEmptyType()) continue;
                slurries.add(slurry);
            }
        }
        return slurries;
    }

    public static List<Slurry> chemicalInTank(@Nonnull ISlurryHandler handler) {
        return SlurryHelper.chemicalInTank(handler, null);
    }

    public static long amountInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable Predicate<SlurryStack> filter) {
        long count = 0L;
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            for (int i = 0; i < ((ISlurryHandler.ISidedSlurryHandler)handler).getTanks(direction); ++i) {
                SlurryStack stack = (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                SlurryStack stack = (SlurryStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long amountInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable Slurry filter) {
        return SlurryHelper.amountInTank(handler, direction, (SlurryStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long amountInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable SlurryStack filter) {
        return SlurryHelper.amountInTank(handler, direction, (SlurryStack stack) -> filter == null || stack.isTypeEqual((ChemicalStack)filter));
    }

    public static long amountInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction) {
        return SlurryHelper.amountInTank(handler, direction, (Predicate<SlurryStack>)null);
    }

    public static long amountInTank(@Nonnull ISlurryHandler handler) {
        return SlurryHelper.amountInTank(handler, null);
    }
}

