/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.upgrades;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.helpers.MagnetHelpers;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;
import net.pedroksl.advanced_ae.xmod.curios.CuriosPlugin;
import org.apache.commons.lang3.mutable.MutableObject;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class UpgradeCards {
    public static boolean walkSpeed(Level level, Player player, ItemStack stack) {
        boolean isNotFlying;
        QuantumArmorBase armor;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        Item item = chest.m_41720_();
        boolean canFly = item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(chest, UpgradeType.FLIGHT);
        boolean bl = isNotFlying = !player.m_150110_().f_35935_;
        if (!player.m_20142_() && (canFly || isNotFlying) && !player.m_20072_()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.WALK_SPEED;
            Item item2 = stack.m_41720_();
            if (item2 instanceof QuantumLeggings && (legs = (QuantumLeggings)item2).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, canFly, stack, chest);
            }
            if (canFly && player.m_150110_().f_35935_) {
                return UpgradeCards.processFlightSpeed(player, chest);
            }
        }
        return false;
    }

    public static boolean sprintSpeed(Level level, Player player, ItemStack stack) {
        boolean isNotFlying;
        QuantumArmorBase armor;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        Item item = chest.m_41720_();
        boolean canFly = item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(chest, UpgradeType.FLIGHT);
        boolean bl = isNotFlying = player.f_19789_ <= 0.0f && !player.m_21255_();
        if (player.m_20142_() && (canFly || isNotFlying) && !player.m_20072_()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.SPRINT_SPEED;
            Item item2 = stack.m_41720_();
            if (item2 instanceof QuantumLeggings && (legs = (QuantumLeggings)item2).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, canFly, stack, chest);
            }
            if (canFly && player.m_150110_().f_35935_) {
                return UpgradeCards.processFlightSpeed(player, chest);
            }
        }
        return false;
    }

    public static boolean swimSpeed(Level level, Player player, ItemStack stack) {
        if (player.m_20072_()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.SWIM_SPEED;
            Item item = stack.m_41720_();
            if (item instanceof QuantumLeggings && (legs = (QuantumLeggings)item).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, false, stack, null);
            }
        }
        return false;
    }

    private static boolean processMovementSpeed(UpgradeType upgrade, Player player, boolean canFly, ItemStack stack, ItemStack chest) {
        Item item = stack.m_41720_();
        if (item instanceof QuantumLeggings) {
            Item item2;
            QuantumLeggings legs = (QuantumLeggings)item;
            boolean slowDown = true;
            float value = upgrade.getSettings().multiplier * (float)legs.getUpgradeValue(stack, upgrade, 0);
            if (!(value > 0.0f) || !(value < 1.0f)) {
                slowDown = false;
                value /= 25.0f;
            }
            if (canFly && player.m_150110_().f_35935_ && chest != null && (item2 = chest.m_41720_()) instanceof QuantumChestplate) {
                QuantumChestplate armor = (QuantumChestplate)item2;
                float flight = (float)armor.getUpgradeValue(chest, UpgradeType.FLIGHT, 0) / 25.0f;
                value = !slowDown ? value + flight : flight;
                slowDown = false;
            }
            if (slowDown && player.m_20096_()) {
                Vec3 motion = player.m_20184_();
                player.m_20256_(motion.m_82542_((double)value, 1.0, (double)value));
                return true;
            }
            if (!slowDown && value > 0.0f) {
                if (!player.m_20096_()) {
                    value /= 4.0f;
                }
                if (player.f_20902_ < 0.0f) {
                    value /= 2.0f;
                }
                player.m_19920_(value, new Vec3((double)Math.signum(player.f_20900_), (double)Math.signum(player.f_20901_), (double)Math.signum(player.f_20902_)));
                return true;
            }
        }
        return false;
    }

    private static boolean processFlightSpeed(Player player, ItemStack chest) {
        QuantumArmorBase armor;
        float value;
        Item item = chest.m_41720_();
        if (item instanceof QuantumArmorBase && (value = (float)(armor = (QuantumArmorBase)item).getUpgradeValue(chest, UpgradeType.FLIGHT, 0) / 25.0f) > 0.0f) {
            if (!player.m_20096_()) {
                value /= 4.0f;
            }
            if (player.f_20902_ < 0.0f) {
                value /= 2.0f;
            }
            player.m_19920_(value, new Vec3((double)Math.signum(player.f_20900_), (double)Math.signum(player.f_20901_), (double)Math.signum(player.f_20902_)));
            return true;
        }
        return false;
    }

    public static boolean creativeFlight(Level level, Player player, ItemStack stack) {
        return UpgradeCards.creativeFlight(level, player, stack, true);
    }

    public static boolean creativeFlight(Level level, Player player, ItemStack stack, boolean equipped) {
        Item item = stack.m_41720_();
        if (item instanceof QuantumChestplate) {
            QuantumChestplate chest = (QuantumChestplate)item;
            UpgradeType upgrade = UpgradeType.FLIGHT;
            if (equipped && chest.isUpgradeEnabledAndPowered(stack, upgrade)) {
                if (!player.m_150110_().f_35936_) {
                    player.m_150110_().f_35936_ = true;
                    player.getPersistentData().m_128379_("aaeFlightCard", true);
                    player.m_6885_();
                    return true;
                }
            } else if (player.m_150110_().f_35936_ && player.getPersistentData().m_128471_("aaeFlightCard")) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                player.getPersistentData().m_128473_("aaeFlightCard");
                player.m_6885_();
            }
        }
        return false;
    }

    public static boolean jumpHeight(Level level, Player player, ItemStack stack) {
        if (!player.m_20072_() && !player.m_21255_()) {
            float value;
            QuantumBoots boots;
            UpgradeType upgrade = UpgradeType.JUMP_HEIGHT;
            Item item = stack.m_41720_();
            if (item instanceof QuantumBoots && (boots = (QuantumBoots)item).isUpgradeEnabledAndPowered(stack, upgrade) && (value = (float)boots.getUpgradeValue(stack, UpgradeType.JUMP_HEIGHT, -1) / 8.0f) > 0.0f) {
                if (player.m_20142_()) {
                    value *= 2.0f;
                }
                player.m_19920_(value, new Vec3(0.0, 1.0, 0.0));
                return true;
            }
        }
        return false;
    }

    public static boolean autoFeed(Level level, Player player, ItemStack stack) {
        IGrid grid;
        QuantumHelmet helmet;
        Item item;
        if (player.m_36324_().m_38721_() && (item = stack.m_41720_()) instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.AUTO_FEED) && helmet.getLinkedPosition(stack) != null && (grid = helmet.getLinkedGrid(stack, level, player)) != null) {
            IStorageService storage = grid.getStorageService();
            List filter = helmet.getFilter(stack, UpgradeType.AUTO_FEED);
            for (GenericStack genStack : filter) {
                AEItemKey itemKey;
                ItemStack foodStack;
                FoodProperties foodProperties;
                AEKey aEKey;
                if (storage.getInventory().extract(genStack.what(), 1L, Actionable.SIMULATE, IActionSource.ofPlayer((Player)player)) <= 0L || !((aEKey = genStack.what()) instanceof AEItemKey) || (foodProperties = (foodStack = (itemKey = (AEItemKey)aEKey).toStack()).getFoodProperties((LivingEntity)player)) == null) continue;
                storage.getInventory().extract(genStack.what(), 1L, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                foodStack = foodStack.m_41671_(level, (LivingEntity)player);
                if (!foodStack.m_41619_()) {
                    storage.getInventory().insert((AEKey)AEItemKey.of((ItemStack)foodStack), (long)foodStack.m_41613_(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean autoStock(Level level, Player player, ItemStack stack) {
        QuantumHelmet helmet;
        Item item = stack.m_41720_();
        if (item instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.AUTO_STOCK) && helmet.getLinkedPosition(stack) != null) {
            if (player.f_36096_ != null && !player.f_36096_.m_142621_().m_41619_()) {
                return false;
            }
            MutableObject errorHolder = new MutableObject();
            IGrid grid = helmet.getLinkedGrid(stack, level, player);
            if (grid != null) {
                IStorageService storage = grid.getStorageService();
                List filter = helmet.getFilter(stack, UpgradeType.AUTO_STOCK);
                boolean didSomething = false;
                KeyCounter inventory = storage.getInventory().getAvailableStacks();
                for (GenericStack genStack : filter) {
                    AEKey aEKey = genStack.what();
                    if (!(aEKey instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    long desiredAmount = genStack.amount();
                    int currentAmount = 0;
                    ArrayList<Integer> slots = new ArrayList<Integer>();
                    for (int x = 0; x < player.m_150109_().m_6643_(); ++x) {
                        ItemStack currentStack = player.m_150109_().m_8020_(x);
                        if (itemKey.toStack().m_41720_() != currentStack.m_41720_()) continue;
                        currentAmount += currentStack.m_41613_();
                        slots.add(x);
                    }
                    long amountDelta = desiredAmount - (long)currentAmount;
                    if (amountDelta > 0L && inventory.get((AEKey)itemKey) > 0L) {
                        long extracted = storage.getInventory().extract(genStack.what(), amountDelta, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                        ItemStack stackToInsert = itemKey.toStack((int)extracted);
                        player.m_36356_(stackToInsert);
                        storage.getInventory().insert(genStack.what(), (long)stackToInsert.m_41613_(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                        didSomething |= extracted > 0L;
                        continue;
                    }
                    if (amountDelta >= 0L) continue;
                    amountDelta = -amountDelta;
                    long inserted = storage.getInventory().insert(genStack.what(), amountDelta, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                    int amountToLeave = (int)desiredAmount + (int)(amountDelta - inserted);
                    for (Integer slot : slots) {
                        ItemStack item2 = player.m_150109_().m_8020_(slot.intValue()).m_41777_();
                        int amountToSet = Math.max(0, Math.min(item2.m_41613_(), amountToLeave));
                        item2.m_41764_(amountToSet);
                        player.m_150109_().m_6836_(slot.intValue(), item2);
                        amountToLeave = Math.max(0, amountToLeave - amountToSet);
                    }
                    didSomething |= inserted > 0L;
                }
                return didSomething;
            }
        }
        return false;
    }

    public static boolean magnet(Level level, Player player, ItemStack stack) {
        QuantumHelmet helmet;
        Item item;
        if (!player.m_5833_() && (item = stack.m_41720_()) instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.MAGNET, level)) {
            int range = helmet.getUpgradeValue(stack, UpgradeType.MAGNET, 5);
            Vec3 pos = player.m_20182_();
            AABB area = MagnetHelpers.getBoundingBox(pos, range);
            List filter = helmet.getFilter(stack, UpgradeType.MAGNET);
            boolean blacklist = helmet.getUpgradeExtra(stack, UpgradeType.MAGNET, false);
            List items = level.m_142425_((EntityTypeTest)EntityType.f_20461_, area, obj -> MagnetHelpers.validEntities(obj, player, filter, blacklist));
            items.forEach(itemEntity -> {
                if (!level.m_5776_() && player.m_150109_().m_36050_(itemEntity.m_32055_()) != -1) {
                    itemEntity.m_6123_(player);
                }
                itemEntity.m_146884_(pos);
            });
            if (!level.m_5776_()) {
                List xps = level.m_45976_(ExperienceOrb.class, area);
                xps.forEach(xp -> {
                    xp.f_19802_ = 0;
                    player.f_36101_ = 0;
                    xp.m_6123_(player);
                });
            }
            return true;
        }
        return false;
    }

    public static boolean regeneration(Level level, Player player, ItemStack stack) {
        QuantumChestplate chest;
        Item item = stack.m_41720_();
        if (item instanceof QuantumChestplate && (chest = (QuantumChestplate)item).isUpgradeEnabledAndPowered(stack, UpgradeType.REGENERATION)) {
            player.m_5634_((float)(0.1 * (double)AAEConfig.instance().getRenegerationPerTick()));
            return true;
        }
        return false;
    }

    public static boolean recharging(Level level, Player player, ItemStack stack) {
        QuantumArmorBase armor;
        Item item = stack.m_41720_();
        if (item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(stack, UpgradeType.CHARGING) && armor.getLinkedPosition(stack) != null) {
            MutableObject errorHolder = new MutableObject();
            IGrid grid = armor.getLinkedGrid(stack, level, player);
            if (grid != null) {
                IEnergyService energy = grid.getEnergyService();
                double currentPower = armor.getAECurrentPower(stack);
                double rate = armor.getChargeRate(stack);
                int afRate = Integer.MAX_VALUE;
                double maxPower = armor.getAEMaxPower(stack);
                double neededPower = Math.min(rate, maxPower - currentPower);
                if (neededPower > 0.0 && Addons.APPFLUX.isLoaded()) {
                    neededPower = Math.min((double)afRate, maxPower - currentPower);
                    neededPower = AppliedFluxPlugin.rechargeAeStorageItem(grid, neededPower, player, stack, armor);
                }
                if (neededPower > 0.0 && energy.getStoredPower() > 0.0) {
                    double extracted = energy.extractAEPower(rate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double remainder = armor.injectAEPower(stack, extracted, Actionable.MODULATE);
                    energy.injectPower(remainder, Actionable.MODULATE);
                }
                if (stack.m_41720_() instanceof QuantumChestplate) {
                    for (int i = 0; i < 36; ++i) {
                        ItemStack item2 = player.m_150109_().m_8020_(i);
                        if (item2.m_41619_()) continue;
                        UpgradeCards.rechargeItem(player, item2, grid, rate, energy);
                    }
                    if (!player.m_21206_().m_41619_()) {
                        UpgradeCards.rechargeItem(player, player.m_21206_(), grid, rate, energy);
                    }
                    if (Addons.CURIOS.isLoaded()) {
                        LazyOptional<ICuriosItemHandler> optionalInv = CuriosPlugin.getCuriosInventory(player);
                        optionalInv.ifPresent(inv -> {
                            IItemHandlerModifiable handler = inv.getEquippedCurios();
                            for (int i = 0; i < handler.getSlots(); ++i) {
                                ItemStack item = handler.getStackInSlot(i);
                                if (item.m_41619_()) continue;
                                UpgradeCards.rechargeItem(player, item, grid, rate, energy);
                            }
                        });
                    }
                }
            }
        }
        return false;
    }

    private static void rechargeItem(Player player, ItemStack stack, IGrid grid, double rate, IEnergyService energyService) {
        LazyOptional capOf = stack.getCapability(ForgeCapabilities.ENERGY);
        int afRate = Integer.MAX_VALUE;
        capOf.ifPresent(cap -> {
            if (cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
                if (Addons.APPFLUX.isLoaded()) {
                    AppliedFluxPlugin.rechargeEnergyStorage(grid, afRate, IActionSource.ofPlayer((Player)player), cap);
                }
                if (energyService.getStoredPower() > 0.0) {
                    double extracted = energyService.extractAEPower(rate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    int inserted = cap.receiveEnergy((int)extracted, false);
                    energyService.injectPower(extracted - (double)inserted, Actionable.MODULATE);
                }
            }
        });
    }
}

