/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderCapacityUpgradeItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderUpgradeItem;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.ImportExportBusPart;
import net.pedroksl.advanced_ae.common.parts.SmallAdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.advanced_ae.common.parts.ThroughputMonitorPart;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPatternItem;

public class AAEItems {
    public static final DeferredRegister<Item> DR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"advanced_ae");
    private static final List<AAEItemDefinition<?>> ITEMS = new ArrayList();
    public static final AAEItemDefinition<PartItem<AdvPatternProviderPart>> ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Extended Pattern Provider", "adv_pattern_provider_part", AdvPatternProviderPart.class, AdvPatternProviderPart::new);
    public static final AAEItemDefinition<PartItem<SmallAdvPatternProviderPart>> SMALL_ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Pattern Provider", "small_adv_pattern_provider_part", SmallAdvPatternProviderPart.class, SmallAdvPatternProviderPart::new);
    public static final AAEItemDefinition<PartItem<StockExportBusPart>> STOCK_EXPORT_BUS = AAEItems.part("ME Stock Export Bus", "stock_export_bus_part", StockExportBusPart.class, StockExportBusPart::new);
    public static final AAEItemDefinition<PartItem<ImportExportBusPart>> IMPORT_EXPORT_BUS = AAEItems.part("ME Import Export Bus", "import_export_bus_part", ImportExportBusPart.class, ImportExportBusPart::new);
    public static final AAEItemDefinition<PartItem<ThroughputMonitorPart>> THROUGHPUT_MONITOR = AAEItems.part("ME Throughput Monitor", "throughput_monitor", ThroughputMonitorPart.class, ThroughputMonitorPart::new);
    public static final AAEItemDefinition<AdvProcessingPatternItem> ADV_PROCESSING_PATTERN = AAEItems.item("Advanced Processing Pattern", "adv_processing_pattern", AdvProcessingPatternItem::new);
    public static final AAEItemDefinition<Item> ADV_PATTERN_PROVIDER_UPGRADE = AAEItems.item("Advanced Pattern Provider Upgrade", "adv_pattern_provider_upgrade", AdvPatternProviderUpgradeItem::new);
    public static final AAEItemDefinition<Item> ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE = AAEItems.item("Advanced Pattern Provider Capacity Upgrade", "adv_pattern_provider_capacity_upgrade", AdvPatternProviderCapacityUpgradeItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_INFUSED_DUST = AAEItems.item("Quantum Infused Dust", "quantum_infused_dust", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_ALLOY = AAEItems.item("Quantum Alloy", "quantum_alloy", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_ALLOY_PLATE = AAEItems.item("Quantum Alloy Plate", "quantum_alloy_plate", p -> new MaterialItem(p.m_41497_(Rarity.EPIC)));
    public static final AAEItemDefinition<MaterialItem> SHATTERED_SINGULARITY = AAEItems.item("Shattered Singularity", "shattered_singularity", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRESS = AAEItems.item("Inscriber Quantum Press", "quantum_processor_press", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRINT = AAEItems.item("Printed Quantum Circuit", "printed_quantum_processor", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR = AAEItems.item("Quantum Processor", "quantum_processor", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_STORAGE_COMPONENT = AAEItems.item("Quantum Storage Component", "quantum_storage_component", MaterialItem::new);
    public static final AAEItemDefinition<AdvPatternEncoderItem> ADV_PATTERN_ENCODER = AAEItems.item("Advanced Pattern Encoder", "adv_pattern_encoder", AdvPatternEncoderItem::new);
    public static final AAEItemDefinition<Item> MONITOR_CONFIGURATOR = AAEItems.item("Throughput Monitor Configurator", "throughput_monitor_configurator", Item::new);
    public static final AAEItemDefinition<QuantumHelmet> QUANTUM_HELMET = AAEItems.item("Quantum Helmet", "quantum_helmet", QuantumHelmet::new);
    public static final AAEItemDefinition<QuantumChestplate> QUANTUM_CHESTPLATE = AAEItems.item("Quantum Chestplate", "quantum_chestplate", QuantumChestplate::new);
    public static final AAEItemDefinition<QuantumLeggings> QUANTUM_LEGGINGS = AAEItems.item("Quantum Leggings", "quantum_leggings", QuantumLeggings::new);
    public static final AAEItemDefinition<QuantumBoots> QUANTUM_BOOTS = AAEItems.item("Quantum Boots", "quantum_boots", QuantumBoots::new);
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> QUANTUM_UPGRADE_BASE = AAEItems.item("Quantum Upgrade Base Card", "quantum_upgrade_base", QuantumUpgradeBaseItem::new);
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> WALK_SPEED_CARD = AAEItems.item("Walk Speed Card", "walk_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WALK_SPEED, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> SPRINT_SPEED_CARD = AAEItems.item("Sprint Speed Card", "sprint_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.SPRINT_SPEED, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> STEP_ASSIST_CARD = AAEItems.item("Step Assist Card", "step_assist_card", p -> new QuantumUpgradeBaseItem(UpgradeType.STEP_ASSIST, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> JUMP_HEIGHT_CARD = AAEItems.item("Jump Height Card", "jump_height_card", p -> new QuantumUpgradeBaseItem(UpgradeType.JUMP_HEIGHT, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> LAVA_IMMUNITY_CARD = AAEItems.item("Lava Immunity Card", "lava_immunity_card", p -> new QuantumUpgradeBaseItem(UpgradeType.LAVA_IMMUNITY, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> FLIGHT_CARD = AAEItems.item("Flight Card", "flight_card", p -> new QuantumUpgradeBaseItem(UpgradeType.FLIGHT, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> WATER_BREATHING_CARD = AAEItems.item("Water Breathing Card", "water_breathing_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WATER_BREATHING, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> AUTO_FEED_CARD = AAEItems.item("Auto Feeding Card", "auto_feeding_card", p -> new QuantumUpgradeBaseItem(UpgradeType.AUTO_FEED, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> AUTO_STOCK_CARD = AAEItems.item("Auto Stock Card", "auto_stock_card", p -> new QuantumUpgradeBaseItem(UpgradeType.AUTO_STOCK, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> MAGNET_CARD = AAEItems.item("Magnet Card", "magnet_card", p -> new QuantumUpgradeBaseItem(UpgradeType.MAGNET, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> HP_BUFFER_CARD = AAEItems.item("HP Buffer Card", "hp_buffer_card", p -> new QuantumUpgradeBaseItem(UpgradeType.HP_BUFFER, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> EVASION_CARD = AAEItems.item("Evasion Card", "evasion_card", p -> new QuantumUpgradeBaseItem(UpgradeType.EVASION, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> REGENERATION_CARD = AAEItems.item("Regeneration Card", "regeneration_card", p -> new QuantumUpgradeBaseItem(UpgradeType.REGENERATION, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> STRENGTH_CARD = AAEItems.item("Strength Card", "strength_card", p -> new QuantumUpgradeBaseItem(UpgradeType.STRENGTH, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> ATTACK_SPEED_CARD = AAEItems.item("Attack Speed Card", "attack_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.ATTACK_SPEED, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> LUCK_CARD = AAEItems.item("Luck Card", "luck_card", p -> new QuantumUpgradeBaseItem(UpgradeType.LUCK, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> REACH_CARD = AAEItems.item("Reach Card", "reach_card", p -> new QuantumUpgradeBaseItem(UpgradeType.REACH, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> SWIM_SPEED_CARD = AAEItems.item("Swim Speed Card", "swim_speed_card", p -> new QuantumUpgradeBaseItem(UpgradeType.SWIM_SPEED, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> NIGHT_VISION_CARD = AAEItems.item("Night Vision Card", "night_vision_card", p -> new QuantumUpgradeBaseItem(UpgradeType.NIGHT_VISION, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> FLIGHT_DRIFT_CARD = AAEItems.item("Flight Drift Card", "flight_drift_card", p -> new QuantumUpgradeBaseItem(UpgradeType.FLIGHT_DRIFT, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> RECHARGING_CARD = AAEItems.item("ME Recharging Card", "recharging_card", p -> new QuantumUpgradeBaseItem(UpgradeType.CHARGING, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> WORKBENCH_CARD = AAEItems.item("Portable Workbench Card", "portable_workbench_card", p -> new QuantumUpgradeBaseItem(UpgradeType.WORKBENCH, (Item.Properties)p));
    public static final AAEItemDefinition<QuantumUpgradeBaseItem> PICK_CRAFT_CARD = AAEItems.item("Pick Craft Card", "pick_craft_card", p -> new QuantumUpgradeBaseItem(UpgradeType.PICK_CRAFT, (Item.Properties)p));

    public static List<AAEItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    public static List<AAEItemDefinition<?>> getQuantumArmor() {
        return ITEMS.stream().filter(item -> item.stack().m_41720_() instanceof QuantumArmorBase).toList();
    }

    public static List<AAEItemDefinition<?>> getQuantumCards() {
        return ITEMS.stream().filter(item -> item.stack().m_41720_() instanceof QuantumUpgradeBaseItem).toList();
    }

    private static <T extends Item> AAEItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        AAEItemDefinition definition = new AAEItemDefinition(englishName, DR.register(id, () -> (Item)factory.apply(new Item.Properties())));
        ITEMS.add(definition);
        return definition;
    }

    private static <T extends IPart> AAEItemDefinition<PartItem<T>> part(String englishName, String id, Class<T> partClass, Function<IPartItem<T>, T> factory) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        return AAEItems.item(englishName, id, p -> new PartItem(p, partClass, factory));
    }
}

