/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.ItemDefinition;
import appeng.util.helpers.ItemComparisonHelper;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class AAEItemDefinition<T extends Item>
implements ItemLike,
Supplier<T> {
    private final String englishName;
    private final RegistryObject<T> item;

    public AAEItemDefinition(String englishName, RegistryObject<T> item) {
        this.englishName = englishName;
        this.item = item;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public ResourceLocation id() {
        return this.item.getId();
    }

    public ItemStack stack() {
        return this.stack(1);
    }

    public ItemStack stack(int stackSize) {
        return new ItemStack((ItemLike)this.item.get(), stackSize);
    }

    public GenericStack genericStack(long stackSize) {
        return new GenericStack((AEKey)AEItemKey.of((ItemLike)((ItemLike)this.item.get())), stackSize);
    }

    public Holder<T> holder() {
        return (Holder)this.item.getHolder().orElseThrow();
    }

    @Deprecated(forRemoval=true, since="1.21")
    public final boolean isSameAs(ItemStack comparableStack) {
        return this.is(comparableStack);
    }

    public final boolean is(ItemStack comparableStack) {
        return ItemComparisonHelper.isEqualItemType((ItemStack)comparableStack, (ItemStack)this.stack());
    }

    public final boolean is(AEKey key) {
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return this.m_5456_() == itemKey.getItem();
        }
        return false;
    }

    public final boolean isSameAs(AEKey key) {
        return this.is(key);
    }

    @Override
    public T get() {
        return (T)((Item)this.item.get());
    }

    public T m_5456_() {
        return (T)((Item)this.item.get());
    }

    public ItemDefinition<T> getItemDefinition() {
        return new ItemDefinition(this.englishName, this.id(), this.m_5456_());
    }
}

