/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.localization.Tooltips;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.ColorContainer;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.FluidTankItemUsePacket;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class FluidTankSlot
extends AbstractWidget {
    private final AbstractContainerScreen<?> screen;
    private TextureAtlasSprite fluidTexture;
    private FluidStack content = FluidStack.EMPTY;
    private final int maxLevel;
    private boolean disableRender = false;
    private final int index;

    public FluidTankSlot(AbstractContainerScreen<?> screen, int index, int x, int y, int width, int height, int maxLevel, Component message) {
        super(x, y, width, height, message);
        this.maxLevel = maxLevel;
        this.screen = screen;
        this.index = index;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_) {
            boolean flag;
            if (this.m_7972_(button) && (flag = this.m_93680_(mouseX, mouseY))) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.handleClick(mouseX, mouseY, button);
                return true;
            }
            return false;
        }
        return false;
    }

    private void handleClick(double mouseX, double mouseY, int button) {
        ItemStack stack = this.screen.m_6262_().m_142621_();
        if (!stack.m_41619_()) {
            LazyOptional forgeCap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            forgeCap.ifPresent(cap -> {
                FluidStack fluidStack = cap.getFluidInTank(0);
                if (fluidStack.getFluid() == this.content.getFluid() || fluidStack.isEmpty() || this.content.isEmpty()) {
                    AEBaseScreen baseScreen;
                    AbstractContainerScreen<?> abstractContainerScreen = this.screen;
                    int actualButton = abstractContainerScreen instanceof AEBaseScreen ? ((baseScreen = (AEBaseScreen)abstractContainerScreen).isHandlingRightClick() ? 1 : 0) : button;
                    AAENetworkHandler.INSTANCE.sendToServer(new FluidTankItemUsePacket(this.index, actualButton));
                }
            });
        }
    }

    public void m_7435_(@NotNull SoundManager handler) {
    }

    public void playDownSound(SoundManager handler, boolean isInsert) {
        if (isInsert) {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11778_, (float)1.0f, (float)1.0f));
        } else {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11781_, (float)1.0f, (float)1.0f));
        }
    }

    public boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.content == null || this.fluidTexture == null || this.disableRender) {
            return;
        }
        ColorContainer argb = new ColorContainer(IClientFluidTypeExtensions.of((Fluid)this.content.getFluid()).getTintColor());
        guiGraphics.m_280246_(argb.r(), argb.g(), argb.b(), argb.a());
        float levels = (float)this.content.getAmount() / 1000.0f / (float)this.maxLevel;
        int usedY = (int)Math.ceil(levels * (float)this.f_93619_);
        float tiles = (float)usedY / (float)this.f_93618_;
        int currentY = this.m_252907_() + this.f_93619_;
        int x = 0;
        while ((float)x < tiles) {
            if (tiles - (float)x > 1.0f) {
                size = this.f_93618_;
                guiGraphics.m_280159_(this.m_252754_(), currentY - size, 0, size, size, this.fluidTexture);
                currentY -= size;
            } else {
                size = (int)Math.ceil((tiles - (float)x) * (float)this.f_93618_);
                guiGraphics.m_280159_(this.m_252754_(), currentY - size, 0, this.f_93618_, size, this.fluidTexture);
            }
            ++x;
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_168797_(@NotNull NarrationElementOutput narration) {
    }

    public void setFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.content = FluidStack.EMPTY;
            this.disableRender = true;
            this.updateTooltip(fluidStack);
            return;
        }
        this.disableRender = false;
        boolean updateTexture = this.content.isEmpty() || fluidStack.getFluid() != this.content.getFluid();
        this.content = fluidStack;
        this.updateTooltip(fluidStack);
        if (updateTexture && !this.content.isEmpty()) {
            IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)this.content.getFluid());
            ResourceLocation texture = properties.getStillTexture(this.content);
            this.fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        }
    }

    private void updateTooltip(FluidStack stack) {
        if (stack.isEmpty()) {
            this.m_257544_(Tooltip.m_257550_((Component)Tooltips.of((Component[])new Component[]{AAEText.TankEmpty.text(), Component.m_237113_((String)"\n"), AAEText.TankAmount.text(new Object[]{0, 16}).m_130948_(Tooltips.NUMBER_TEXT)})));
            return;
        }
        GenericStack genericStack = GenericStack.fromFluidStack((FluidStack)this.content);
        if (genericStack != null) {
            this.m_257544_(Tooltip.m_257550_((Component)Tooltips.of((Component[])new Component[]{stack.getDisplayName(), Component.m_237113_((String)"\n"), Tooltips.ofAmount((GenericStack)genericStack), Component.m_237113_((String)"\n"), Component.m_237113_((String)FluidTankSlot.getModDisplayNameFromId(genericStack.what().getModId())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})})));
        }
    }

    private static String getModDisplayNameFromId(String modId) {
        Optional container = ModList.get().getModContainerById(modId);
        if (modId.equals("c")) {
            return "Common";
        }
        container = ModList.get().getModContainerById(modId);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        container = ModList.get().getModContainerById(modId.replace('_', '-'));
        return container.isPresent() ? ((ModContainer)container.get()).getModInfo().getDisplayName() : WordUtils.capitalizeFully((String)modId.replace('_', ' '));
    }
}

