/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics.option;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.api.IWandUpgrade;
import thetadev.constructionwand.basics.ReplacementRegistry;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.OptionBoolean;
import thetadev.constructionwand.basics.option.OptionEnum;
import thetadev.constructionwand.basics.option.WandUpgradesSelectable;
import thetadev.constructionwand.items.core.CoreDefault;

public class WandOptions {
    public final CompoundTag tag;
    private static final String TAG_ROOT = "wand_options";
    public final WandUpgradesSelectable<IWandCore> cores;
    public final OptionEnum<LOCK> lock;
    public final OptionEnum<DIRECTION> direction;
    public final OptionBoolean replace;
    public final OptionEnum<MATCH> match;
    public final OptionBoolean random;
    public final IOption<?>[] allOptions;

    public WandOptions(ItemStack wandStack) {
        this.tag = wandStack.m_41698_(TAG_ROOT);
        this.cores = new WandUpgradesSelectable<CoreDefault>(this.tag, "cores", new CoreDefault());
        this.lock = new OptionEnum<LOCK>(this.tag, "lock", LOCK.class, LOCK.NOLOCK);
        this.direction = new OptionEnum<DIRECTION>(this.tag, "direction", DIRECTION.class, DIRECTION.TARGET);
        this.replace = new OptionBoolean(this.tag, "replace", true);
        this.match = new OptionEnum<MATCH>(this.tag, "match", MATCH.class, MATCH.SIMILAR);
        this.random = new OptionBoolean(this.tag, "random", false);
        this.allOptions = new IOption[]{this.cores, this.lock, this.direction, this.replace, this.match, this.random};
    }

    @Nullable
    public IOption<?> get(String key) {
        for (IOption<?> option : this.allOptions) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public boolean testLock(LOCK l) {
        if (this.lock.get() == LOCK.NOLOCK) {
            return true;
        }
        return this.lock.get() == l;
    }

    public boolean matchBlocks(Block b1, Block b2) {
        switch ((MATCH)((Object)this.match.get())) {
            case EXACT: {
                return b1 == b2;
            }
            case SIMILAR: {
                return ReplacementRegistry.matchBlocks(b1, b2);
            }
            case ANY: {
                return b1 != Blocks.f_50016_ && b2 != Blocks.f_50016_;
            }
        }
        return false;
    }

    public boolean hasUpgrade(IWandUpgrade upgrade) {
        if (upgrade instanceof IWandCore) {
            return this.cores.hasUpgrade((IWandCore)upgrade);
        }
        return false;
    }

    public boolean addUpgrade(IWandUpgrade upgrade) {
        if (upgrade instanceof IWandCore) {
            return this.cores.addUpgrade((IWandCore)upgrade);
        }
        return false;
    }

    public static enum LOCK {
        HORIZONTAL,
        VERTICAL,
        NORTHSOUTH,
        EASTWEST,
        NOLOCK;

    }

    public static enum DIRECTION {
        TARGET,
        PLAYER;

    }

    public static enum MATCH {
        EXACT,
        SIMILAR,
        ANY;

    }
}

