/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Main;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CropEvents {
    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        if (CropEvents.harvest(event.getHitVec(), event.getPos(), event.getEntity())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean harvest(BlockHitResult hitResult, BlockPos pos, Player player) {
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        Block blockClicked = state.m_60734_();
        if (Main.SERVER_CONFIG.reapWhitelist.stream().noneMatch(tag -> tag.contains(state.m_60734_()))) {
            return false;
        }
        BonemealableBlock growable = CropEvents.getGrowable(blockClicked);
        if (growable == null) {
            return false;
        }
        if (growable.m_7370_((LevelReader)world, pos, state, world.f_46443_)) {
            return false;
        }
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return true;
        }
        LootParams.Builder context = new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81455_, (Object)player);
        if (((Boolean)Main.SERVER_CONFIG.considerTool.get()).booleanValue()) {
            context.m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_());
        } else {
            context.m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
        }
        List drops = state.m_287290_(context);
        BlockState newState = blockClicked.m_49966_();
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.f_61374_))) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.f_61409_))) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0));
        }
        world.m_46597_(pos, newState);
        ItemStack clickedBlockItem = state.getCloneItemStack((HitResult)hitResult, (BlockGetter)world, pos, player);
        for (ItemStack stack : drops) {
            if (stack.m_150930_(clickedBlockItem.m_41720_())) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        return true;
    }

    private static BonemealableBlock getGrowable(Block block) {
        if (block instanceof BonemealableBlock) {
            return (BonemealableBlock)block;
        }
        if (block instanceof NetherWartBlock) {
            return new BonemealableBlock(){

                public boolean m_7370_(LevelReader levelReader, BlockPos pos, BlockState state, boolean isClient) {
                    return (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) < 3;
                }

                public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
                    return false;
                }

                public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
                }
            };
        }
        return null;
    }
}

