/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateFilterTag {
    boolean allowList;
    List<String> tags;

    public PacketUpdateFilterTag(boolean allowList, List<String> tags) {
        this.allowList = allowList;
        this.tags = tags;
    }

    public static void encode(PacketUpdateFilterTag msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.allowList);
        buffer.m_236828_(msg.tags, FriendlyByteBuf::m_130070_);
    }

    public static PacketUpdateFilterTag decode(FriendlyByteBuf buffer) {
        return new PacketUpdateFilterTag(buffer.readBoolean(), (List)buffer.m_236838_(Lists::newArrayListWithCapacity, FriendlyByteBuf::m_130277_));
    }

    public static class Handler {
        public static void handle(PacketUpdateFilterTag msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                AbstractContainerMenu container = player.f_36096_;
                if (container == null) {
                    return;
                }
                if (container instanceof FilterTagContainer) {
                    stack = ((FilterTagContainer)container).filterItem;
                    FilterTag.setAllowList(stack, msg.allowList);
                    FilterTag.setTags(stack, msg.tags);
                }
                if (container instanceof FilterNBTContainer) {
                    stack = ((FilterNBTContainer)container).filterItem;
                    FilterNBT.setAllowList(stack, msg.allowList);
                    FilterNBT.setTags(stack, msg.tags);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

