/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities;

import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.DimBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LaserConnectorAdvBE
extends BaseLaserBE {
    protected DimBlockPos partnerDimBlockPos;

    public LaserConnectorAdvBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.LaserConnectorAdv_BE.get(), pos, state);
    }

    public DimBlockPos getPartnerDimBlockPos() {
        return this.partnerDimBlockPos;
    }

    public void setPartnerDimBlockPos(DimBlockPos partnerDimBlockPos) {
        this.partnerDimBlockPos = partnerDimBlockPos;
        this.markDirtyClient();
    }

    public boolean isPartnerNodeConnected(DimBlockPos pos) {
        return this.partnerDimBlockPos != null && this.partnerDimBlockPos.equals(pos);
    }

    public void handleAdvancedConnection(LaserConnectorAdvBE be) {
        DimBlockPos connectingDimPos = new DimBlockPos(be.m_58904_(), be.m_58899_());
        if (this.isPartnerNodeConnected(connectingDimPos)) {
            this.removePartnerConnection();
        } else {
            this.addPartnerConnection(connectingDimPos, be);
        }
    }

    public void addPartnerConnection(DimBlockPos connectingDimPos, LaserConnectorAdvBE be) {
        if (this.getPartnerDimBlockPos() != null) {
            this.removePartnerConnection();
        }
        if (be.getPartnerDimBlockPos() != null) {
            be.removePartnerConnection();
        }
        this.setPartnerDimBlockPos(connectingDimPos);
        be.setPartnerDimBlockPos(new DimBlockPos(this.m_58904_(), this.m_58899_()));
        if (this.getColor().equals(this.getDefaultColor()) && !be.getColor().equals(be.getDefaultColor())) {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        } else if (be.getColor().equals(be.getDefaultColor()) && !this.getColor().equals(this.getDefaultColor())) {
            be.setColor(this.getColor(), this.getWrenchAlpha());
        } else {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        }
        this.discoverAllNodes();
    }

    public void removePartnerConnection() {
        DimBlockPos partnerDimPos;
        BlockEntity partnerBE;
        if (this.getPartnerDimBlockPos() != null && (partnerBE = (partnerDimPos = this.getPartnerDimBlockPos()).getLevel(this.f_58857_.m_7654_()).m_7702_(partnerDimPos.blockPos)) instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE be = (LaserConnectorAdvBE)partnerBE;
            be.setPartnerDimBlockPos(null);
            be.discoverAllNodes();
        }
        this.setPartnerDimBlockPos(null);
        this.discoverAllNodes();
    }

    @Override
    public void disconnectAllNodes() {
        this.removePartnerConnection();
        super.disconnectAllNodes();
    }

    @Override
    public void validateConnections(BlockPos originalPos) {
        DimBlockPos partner = this.getPartnerDimBlockPos();
        if (partner == null) {
            this.removePartnerConnection();
            super.validateConnections(originalPos);
            return;
        }
        BlockEntity be = partner.getLevel(this.m_58904_().m_7654_()).m_7702_(partner.blockPos);
        if (be instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)be;
            this.addPartnerConnection(partner, laserConnectorAdvBE);
        } else {
            this.removePartnerConnection();
        }
        super.validateConnections(originalPos);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("partnerDimPos")) {
            this.setPartnerDimBlockPos(new DimBlockPos(tag.m_128469_("partnerDimPos")));
        } else {
            this.setPartnerDimBlockPos(null);
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.getPartnerDimBlockPos() != null) {
            tag.m_128365_("partnerDimPos", (Tag)this.getPartnerDimBlockPos().toNBT());
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }
}

