/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.api.accounts;

import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.config.impl.MessageIgnoreConfig;
import com.hypherionmc.sdlink.core.services.SDLinkPlatform;
import com.hypherionmc.sdlink.util.SDLinkChatUtils;
import lombok.Generated;

public final class DiscordAuthor {
    public static final DiscordAuthor SERVER = new DiscordAuthor(SDLinkConfig.INSTANCE.channelsAndWebhooks.serverName, SDLinkConfig.INSTANCE.channelsAndWebhooks.serverAvatar, "server", true, "");
    private String displayName;
    private final String avatar;
    private final boolean isServer;
    private String username;
    private String uuid;
    private BridgedGameProfile profile = null;
    String realPlayerAvatar = "";
    String realPlayerName = "";

    private DiscordAuthor(String displayName, String avatar, String username, boolean isServer, String uuid) {
        this.avatar = avatar;
        this.username = username;
        this.isServer = isServer;
        this.uuid = uuid;
        this.displayName = displayName;
        this.displayName = this.displayName.replace("_", "\\_");
        this.displayName = SDLinkChatUtils.applyFiltering(this.displayName, i -> i.appliesTo == MessageIgnoreConfig.AppliesTo.DISCORD && (i.target == MessageIgnoreConfig.FilterTarget.USERNAME || i.target == MessageIgnoreConfig.FilterTarget.BOTH));
        if (this.displayName == null || this.displayName.isEmpty()) {
            this.displayName = displayName;
            this.displayName = this.displayName.replace("_", "\\_");
        }
    }

    public static DiscordAuthor of(String displayName, String uuid, String username) {
        return new DiscordAuthor(displayName, SDLinkConfig.INSTANCE.chatConfig.playerAvatarType.resolve(SDLinkPlatform.minecraftHelper.isOnlineMode() ? uuid : username), username, false, uuid);
    }

    public static DiscordAuthor of(String displayName, String avatar, String username, boolean server) {
        return new DiscordAuthor(displayName, avatar, username, server, username);
    }

    public DiscordAuthor setPlayerAvatar(String usr, String userid) {
        this.realPlayerAvatar = SDLinkConfig.INSTANCE.chatConfig.playerAvatarType.resolve(SDLinkPlatform.minecraftHelper.isOnlineMode() ? userid : usr);
        return this;
    }

    public DiscordAuthor setPlayerName(String name) {
        this.realPlayerName = name;
        return this;
    }

    public DiscordAuthor setGameProfile(BridgedGameProfile profile) {
        this.profile = profile;
        this.username = profile.getName();
        this.uuid = profile.getId().toString();
        return this;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getAvatar() {
        return this.avatar;
    }

    @Generated
    public boolean isServer() {
        return this.isServer;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public BridgedGameProfile getProfile() {
        return this.profile;
    }

    @Generated
    public String getRealPlayerAvatar() {
        return this.realPlayerAvatar;
    }

    @Generated
    public String getRealPlayerName() {
        return this.realPlayerName;
    }
}

