/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.modifier;

import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ItemModifier {
    private final Predicate<ItemStack> predicate;
    private final TagKey<Item> incompatibleItems;
    private final TagKey<Enchantment> incompatibleEnchantments;
    private final int startTooltipColor;
    private final int endTooltipColor;
    private List<ItemStack> cachedValidItems;

    public ItemModifier(Predicate<ItemStack> predicate, TagKey<Item> incompatibleItems, TagKey<Enchantment> incompatibleEnchantments, int startTooltipColor, int endTooltipColor) {
        this.predicate = predicate;
        this.incompatibleItems = incompatibleItems;
        this.incompatibleEnchantments = incompatibleEnchantments;
        this.startTooltipColor = startTooltipColor;
        this.endTooltipColor = endTooltipColor;
    }

    public void onApplied(ItemStack stack) {
    }

    public MutableComponent getComponent() {
        ResourceLocation name = this.getRegistryName();
        if (name == null) {
            return Component.m_237113_((String)"");
        }
        return Component.m_237115_((String)("modifier." + name.m_135827_() + "." + name.m_135815_()));
    }

    public ResourceLocation getRegistryName() {
        return FARegistries.ITEM_MODIFIER_REGISTRY.get().getKey((Object)this);
    }

    public ResourceLocation getTooltipTexture() {
        return new ResourceLocation("forbidden_arcanus", "textures/gui/tooltip/" + this.getRegistryName().m_135815_() + ".png");
    }

    public TagKey<Item> getIncompatibleItems() {
        return this.incompatibleItems;
    }

    public TagKey<Enchantment> getIncompatibleEnchantments() {
        return this.incompatibleEnchantments;
    }

    public boolean canItemContainModifier(ItemStack stack) {
        if (stack.m_204117_(this.getIncompatibleItems()) || !this.predicate.test(stack)) {
            return false;
        }
        ITagManager tagManager = ForgeRegistries.ENCHANTMENTS.tags();
        if (tagManager == null) {
            return false;
        }
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().noneMatch(enchantment -> tagManager.getTag(this.getIncompatibleEnchantments()).contains(enchantment));
    }

    public List<ItemStack> getValidItems() {
        if (this.cachedValidItems == null) {
            this.cachedValidItems = ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(this::canItemContainModifier).toList();
        }
        return this.cachedValidItems;
    }

    public void clearCachedValidItems() {
        this.cachedValidItems = null;
    }

    public int getStartTooltipColor() {
        return this.startTooltipColor;
    }

    public int getEndTooltipColor() {
        return this.endTooltipColor;
    }
}

