/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.MagicCircle;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceManager;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesContainer;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.block.entity.forge.input.HephaestusForgeInput;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.ValidRitualIndicator;
import com.stal111.forbidden_arcanus.common.inventory.HephaestusForgeMenu;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerCache;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateItemInSlotPacket;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.stal111.forbidden_arcanus.util.ValueNotifier;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.api.common.block.entity.forge.ValhelsiaContainerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HephaestusForgeBlockEntity
extends ValhelsiaContainerBlockEntity<HephaestusForgeBlockEntity>
implements EssencesContainer {
    public static final int MAIN_SLOT = 4;
    public static final EnumMap<EssenceType, Integer> SLOT_FROM_ESSENCE_TYPE_MAP = (EnumMap)Util.m_137469_(new EnumMap(EssenceType.class), map -> {
        map.put(EssenceType.AUREAL, 5);
        map.put(EssenceType.SOULS, 6);
        map.put(EssenceType.BLOOD, 7);
        map.put(EssenceType.EXPERIENCE, 8);
    });
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData hephaestusForgeData = new ContainerData(){

        public int m_6413_(int index) {
            EssenceManager manager = HephaestusForgeBlockEntity.this.getEssenceManager();
            return switch (index) {
                case 0 -> manager.getAureal();
                case 1 -> manager.getSouls();
                case 2 -> manager.getBlood();
                case 3 -> manager.getExperience();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            EssenceManager manager = HephaestusForgeBlockEntity.this.getEssenceManager();
            switch (index) {
                case 0: {
                    manager.setAureal(value);
                    break;
                }
                case 1: {
                    manager.setSouls(value);
                    break;
                }
                case 2: {
                    manager.setBlood(value);
                    break;
                }
                case 3: {
                    manager.setExperience(value);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final EssenceManager essenceManager;
    private final RitualManager ritualManager;
    private final ValueNotifier<HephaestusForgeLevel> forgeLevel;
    private MagicCircle magicCircle;
    private ValidRitualIndicator validRitualIndicator;
    private int displayCounter;

    public HephaestusForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get(), pos, state, 9, (slot, stack) -> {
            if (HephaestusForgeMenu.ENHANCERS_SLOTS.contains(slot)) {
                return EnhancerCache.get(stack.m_41720_()).isPresent();
            }
            return true;
        });
        HephaestusForgeLevel level = HephaestusForgeLevel.getFromIndex((Integer)state.m_61143_((Property)HephaestusForgeBlock.TIER));
        this.ritualManager = new RitualManager(new MainSlotAccessor(this), () -> Stream.of(this.getStack(0), this.getStack(1), this.getStack(2), this.getStack(3)).map(stack -> EnhancerCache.get(stack.m_41720_())).filter(Optional::isPresent).map(Optional::orElseThrow).toList(), level.getAsInt());
        this.essenceManager = new EssenceManager(level.getMaxEssences(), this.ritualManager::updateValidRitual);
        this.forgeLevel = ValueNotifier.of(level, forgeTier -> {
            this.ritualManager.setForgeTier(forgeTier.getAsInt());
            this.essenceManager.setMaxEssences(forgeTier.getMaxEssences());
        });
    }

    public void m_142339_(@NotNull Level level) {
        super.m_142339_(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.ritualManager.setup(serverLevel, this.m_58899_());
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HephaestusForgeBlockEntity blockEntity) {
        if (blockEntity.hasMagicCircle()) {
            blockEntity.magicCircle.tick();
        }
        if (blockEntity.hasValidRitualIndicator()) {
            blockEntity.validRitualIndicator.tick();
        }
        ++blockEntity.displayCounter;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HephaestusForgeBlockEntity blockEntity) {
        for (EssenceType type : EssenceType.values()) {
            int slot = SLOT_FROM_ESSENCE_TYPE_MAP.get((Object)type);
            ItemStack stack = blockEntity.getStack(slot);
            if (stack.m_41619_()) continue;
            blockEntity.getInput(level, stack, type).ifPresent(input -> {
                blockEntity.fillWith(type, stack, (HephaestusForgeInput)input, slot);
                blockEntity.m_6596_();
            });
        }
        if (level.m_46467_() % 80L == 0L) {
            ((HephaestusForgeBlock)state.m_60734_()).updateState(state, level, pos);
        }
        if (level.m_46467_() % 20L == 0L) {
            blockEntity.essenceManager.tick(level, pos);
        }
        blockEntity.ritualManager.tick(blockEntity.essenceManager.getCurrentEssences());
    }

    protected void onSlotChanged(int slot) {
        if (this.f_58857_ == null) {
            return;
        }
        if (slot == 4) {
            if (this.getStack(slot).m_41619_() && this.getRitualManager().isRitualActive()) {
                this.getRitualManager().failRitual();
            } else {
                this.getRitualManager().updateValidRitual(this.essenceManager.getCurrentEssences());
            }
            NetworkHandler.sendToTrackingChunk(this.f_58857_.m_46745_(this.f_58858_), new UpdateItemInSlotPacket(this.f_58858_, this.getStack(slot), slot));
        } else if (HephaestusForgeMenu.ENHANCERS_SLOTS.contains(slot)) {
            this.getRitualManager().updateValidRitual(this.essenceManager.getCurrentEssences());
        }
    }

    private Optional<HephaestusForgeInput> getInput(Level level, ItemStack stack, EssenceType essenceType) {
        if (this.essenceManager.isEssenceFull(essenceType)) {
            return Optional.empty();
        }
        return level.m_9598_().m_175515_(FARegistries.FORGE_INPUT).m_203611_().map(Holder::get).filter(input -> input.canInput(essenceType, stack)).findFirst();
    }

    public void setForgeLevel(HephaestusForgeLevel level) {
        this.forgeLevel.set(level);
    }

    public ContainerData getHephaestusForgeData() {
        return this.hephaestusForgeData;
    }

    public EssenceManager getEssenceManager() {
        return this.essenceManager;
    }

    public boolean hasMagicCircle() {
        return this.magicCircle != null;
    }

    public MagicCircle getMagicCircle() {
        return this.magicCircle;
    }

    public void setMagicCircle(@NotNull MagicCircle magicCircle) {
        this.magicCircle = magicCircle;
    }

    public void removeMagicCircle() {
        this.magicCircle = null;
        this.validRitualIndicator = null;
    }

    public boolean hasValidRitualIndicator() {
        return this.validRitualIndicator != null;
    }

    public ValidRitualIndicator getValidRitualIndicator() {
        return this.validRitualIndicator;
    }

    public void createValidRitualIndicator(boolean playAnimation) {
        this.validRitualIndicator = new ValidRitualIndicator(playAnimation);
    }

    public void removeValidRitualIndicator() {
        this.validRitualIndicator = null;
    }

    public void fillWith(EssenceType essenceType, ItemStack stack, HephaestusForgeInput input, int slot) {
        int value = input.getInputValue(essenceType, stack, Objects.requireNonNull(this.m_58904_()).m_213780_());
        this.getEssenceManager().increaseEssence(essenceType, value);
        input.finishInput(essenceType, stack, this, slot, value);
    }

    public RitualManager getRitualManager() {
        return this.ritualManager;
    }

    public int getDisplayCounter() {
        return this.displayCounter;
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.saveInventory(tag);
        tag.m_128365_("Ritual", (Tag)this.getRitualManager().save(new CompoundTag()));
        tag.m_128365_("Essences", (Tag)this.getEssenceManager().save(new CompoundTag()));
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadInventory(tag);
        this.getRitualManager().load(tag.m_128469_("Ritual"));
        this.getEssenceManager().load(tag.m_128469_("Essences"));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        AABB boundingBox = new AABB(this.m_58899_()).m_82363_(0.0, 1.0, 0.0);
        if (this.useExpandedRenderBoundingBox()) {
            boundingBox = boundingBox.m_82377_(2.5, 0.0, 2.5);
        }
        return boundingBox;
    }

    public boolean useExpandedRenderBoundingBox() {
        return this.getRitualManager().isRitualActive() || this.hasValidRitualIndicator();
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.forbidden_arcanus.hephaestus_forge");
    }

    protected AbstractContainerMenu createMenu(int containerId, @NotNull MenuCreationContext creationContext) {
        return new HephaestusForgeMenu(containerId, this.getItemStackHandler(), this.getHephaestusForgeData(), (MenuCreationContext<HephaestusForgeBlockEntity, IItemHandler>)creationContext);
    }

    @Override
    public void setEssencesLimit(EssencesDefinition definition) {
        this.essenceManager.setMaxEssences(definition);
    }

    @Override
    public EssencesDefinition getEssences() {
        return this.essenceManager.getCurrentEssences();
    }

    @Override
    public void setEssences(EssencesDefinition definition) {
        definition.forEach(this.essenceManager::setEssence);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> ((HephaestusForgeBlockEntity)this).getItemStackHandler());
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    private record MainSlotAccessor(HephaestusForgeBlockEntity blockEntity) implements RitualManager.MainIngredientAccessor
    {
        @Override
        public ItemStack get() {
            return this.blockEntity.getStack(4);
        }

        @Override
        public void set(ItemStack stack) {
            this.blockEntity.setStack(4, stack);
        }
    }
}

