/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.entity;

import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.common.entity.ModBoat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = new HashMap<ModBoat.Type, Pair<ResourceLocation, ListModel<Boat>>>();

    public ModBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context, hasChest);
        for (ModBoat.Type type : ModBoat.Type.values()) {
            this.boatResources.put(type, (Pair<ResourceLocation, ListModel<Boat>>)Pair.of((Object)type.getTexture(hasChest), this.createBoatModel(context, type, hasChest)));
        }
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ModBoat.Type type, boolean hasChest) {
        ModelLayerLocation layerLocation = new ModelLayerLocation(new ResourceLocation("forbidden_arcanus", hasChest ? type.getChestModelLocation() : type.getModelLocation()), "main");
        ModelPart part = context.m_174023_(layerLocation);
        return hasChest ? new ChestBoatModel(part) : new BoatModel(part);
    }

    @Nonnull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@Nonnull Boat boat) {
        if (boat instanceof CustomBoat) {
            CustomBoat customBoat = (CustomBoat)boat;
            return this.boatResources.get((Object)customBoat.getWoodType());
        }
        return super.getModelWithLocation(boat);
    }
}

