/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.container;

import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class InfiniteFluidSourceCache
implements IFluidHandler {
    private final FluidStack _fluidStack;

    public InfiniteFluidSourceCache(Fluid fluid) {
        this._fluidStack = new FluidStack(fluid, 1000000000);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this._fluidStack;
    }

    public int getTankCapacity(int tank) {
        return this._fluidStack.getAmount();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this._fluidStack.isFluidEqual(resource)) {
            FluidStack result = resource.copy();
            result.setAmount(Math.min(result.getAmount(), this._fluidStack.getAmount()));
            return result;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack result = this._fluidStack.copy();
        result.setAmount(Math.min(result.getAmount(), this._fluidStack.getAmount()));
        return result;
    }
}

