/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;

public interface ITickable {
    public static boolean shouldTick(@NotNull Level level, int seed, int frequency) {
        return (level.m_46467_() + (long)seed + 1L) % (long)frequency == 0L;
    }

    @NotNull
    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return (lvl, pos, blockState, entity) -> {
            CoreBlockEntity coreEntity;
            if (entity instanceof CoreBlockEntity && !(coreEntity = (CoreBlockEntity)entity).isUniqueTick(lvl)) {
                return;
            }
            if (level.f_46443_) {
                if (entity instanceof Client) {
                    tickEntity = (Client)entity;
                    tickEntity.tickClient(lvl, pos, blockState);
                }
            } else if (entity instanceof Server) {
                tickEntity = (Server)entity;
                tickEntity.tickServer(lvl, pos, blockState);
            }
        };
    }

    public static interface Client {
        public void tickClient(@NotNull Level var1, @NotNull BlockPos var2, @NotNull BlockState var3);
    }

    public static interface Server {
        public void tickServer(@NotNull Level var1, @NotNull BlockPos var2, @NotNull BlockState var3);
    }
}

