/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.data.BlockModelType;

public class BlockContent
implements IContent<BlockContent>,
ItemLike {
    private final RegistryObject<Block> _registryBlock;
    private final RegistryObject<Item> _registryItem;
    private final RegistryObject<BlockEntityType<?>> _registryEntity;
    private String _modelPath;
    protected final HashMap<String, String> _localizations = new HashMap();
    private BlockModelType _modelType;
    private boolean _customBreakRules;
    private boolean _customItemModel;
    private int _color;
    private RegistryObject<CreativeModeTab> _tab;
    int toolTipCount;

    public BlockContent(RegistryObject<Block> block, RegistryObject<Item> item) {
        this(block, item, null);
        this._color = -1;
    }

    public BlockContent(RegistryObject<Block> block, RegistryObject<Item> item, RegistryObject<BlockEntityType<?>> entity) {
        this._registryBlock = block;
        this._registryItem = item;
        this._modelPath = block.getId().m_135815_();
        this._modelType = BlockModelType.Block;
        this._registryEntity = entity;
    }

    public Block block() {
        return (Block)this._registryBlock.get();
    }

    public Item item() {
        return (Item)this._registryItem.get();
    }

    public <T extends BlockEntity> BlockEntityType<T> entity() {
        return (BlockEntityType)this._registryEntity.get();
    }

    public BlockContent withModelType(BlockModelType type) {
        this._modelType = type;
        return this;
    }

    public BlockContent withCustomBreakRule() {
        this._customBreakRules = true;
        return this;
    }

    public BlockContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    public BlockContent withColor(int color) {
        this._color = color;
        return this;
    }

    public int getColor() {
        return this._color;
    }

    public BlockModelType getModelType() {
        return this._modelType;
    }

    public boolean hasCustomBreakRules() {
        return this._customBreakRules;
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }

    @Override
    public ResourceLocation id() {
        return this._registryBlock.getId();
    }

    @Override
    public BlockContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public BlockContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public RegistryObject<CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public BlockContent setTab(RegistryObject<CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    @Override
    public BlockContent enableToolTip(int count) {
        this.toolTipCount = count;
        return this;
    }

    @Override
    public void setToolTip() {
        block4: {
            block3: {
                if (this.toolTipCount <= 0) {
                    return;
                }
                Item item = this.item();
                if (!(item instanceof XyItem)) break block3;
                XyItem item2 = (XyItem)item;
                for (int i = 0; i < this.toolTipCount; ++i) {
                    item2.addToolTip((Component)Component.m_237115_((String)("item.xycraft_machines." + this.id().m_135815_() + ".tooltip_" + i)));
                }
                break block4;
            }
            Item i = this.item();
            if (!(i instanceof XyBlockItem)) break block4;
            XyBlockItem blockItem = (XyBlockItem)i;
            for (int i2 = 0; i2 < this.toolTipCount; ++i2) {
                blockItem.addToolTip((Component)Component.m_237115_((String)("item.xycraft_machines." + this.id().m_135815_() + ".tooltip_" + i2)));
            }
        }
    }

    @NotNull
    public Item m_5456_() {
        return this.item();
    }
}

