/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class PonderLang {
    public static final String PATH = "kubejs/assets/ponderjs_generated/lang/%lang%.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public boolean generate(String langName) {
        File file = new File(PATH.replace("%lang%", langName));
        JsonObject existingLang = this.read(file);
        JsonObject currentLang = this.createFromLocalization();
        if (currentLang.equals((Object)existingLang)) {
            return false;
        }
        PonderJS.LOGGER.info("PonderJS - New lang file differ from existing lang file, generating new lang file.\n Old Lang size: {} \n\n New lang size: {}", (Object)(existingLang == null ? 0 : existingLang.size()), (Object)currentLang.size());
        return this.write(file, currentLang);
    }

    private boolean write(File file, JsonObject currentLang) {
        try {
            String output = GSON.toJson((JsonElement)currentLang);
            FileUtils.writeStringToFile((File)file, (String)output, (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            PonderJS.LOGGER.error((Object)e);
            return false;
        }
    }

    @Nullable
    protected JsonObject read(File file) {
        if (file.exists()) {
            try {
                String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                return (JsonObject)GSON.fromJson(s, JsonObject.class);
            }
            catch (IOException e) {
                PonderJS.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    public JsonObject createFromLocalization() {
        PonderJS.STORIES_MANAGER.compileLang();
        JsonObject object = new JsonObject();
        PonderJS.NAMESPACES.forEach(namespace -> PonderLocalization.provideLang((String)namespace, (arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1)));
        return object;
    }
}

