/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.util.math;

import net.minecraft.nbt.CompoundTag;

public class RangedDouble {
    private double value;
    private double min;
    private double max;

    public RangedDouble(double size) {
        this(0.0, size - 1.0);
    }

    public RangedDouble(double min, double max) {
        this(0.0, min, max);
    }

    public RangedDouble(double value, double min, double max) {
        this.value = value;
        this.min = min;
        this.max = max;
        if (min >= max) {
            throw new IllegalArgumentException("The min value: " + min + " should be smaller than max value: " + max);
        }
    }

    public RangedDouble read(CompoundTag nbt, String key) {
        this.value = nbt.m_128459_(key);
        return this;
    }

    public CompoundTag writ(CompoundTag nbt, String key, double value) {
        nbt.m_128347_(key, value);
        return nbt;
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = Math.min(this.max, Math.max(this.min, value));
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }
}

