/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.lib.logistics.inventory.slot.ITexturedSlot;

public class AbstractContainerScreen<C extends AbstractContainer>
extends net.minecraft.client.gui.screens.inventory.AbstractContainerScreen<C> {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final Texture backGround;
    @Nullable
    protected Runnable delayedClick;
    protected int clickDelay;

    public AbstractContainerScreen(C container, Inventory inv, Component title, Texture backGround) {
        super(container, inv, title);
        this.backGround = backGround;
        this.f_97726_ = backGround.getWidth();
        this.f_97727_ = backGround.getHeight();
    }

    public void setDelayedClick(int delay, @Nullable Runnable delayedClick) {
        this.clickDelay = delay;
        this.delayedClick = delayedClick;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.delayedClick != null && this.clickDelay >= 0) {
            --this.clickDelay;
            if (this.clickDelay == 0) {
                this.delayedClick.run();
                this.delayedClick = null;
            }
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.m_280072_(gui, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(gui, partialTicks, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics gui, int mouseX, int mouseY) {
        this.drawForeground(gui, mouseX, mouseY);
    }

    protected void drawBackground(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.backGround.draw(gui, this.f_97735_, this.f_97736_);
    }

    protected void drawForeground(GuiGraphics gui, int mouseX, int mouseY) {
        this.drawTitle(gui, 0, 0);
    }

    protected void drawTitle(GuiGraphics gui, int x, int y) {
        String title = this.f_96539_.getString();
        int width = this.f_96547_.m_92895_(title);
        gui.m_280488_(this.f_96547_, title, x + this.f_97726_ / 2 - width / 2, y - 14, 0x999999);
    }

    public void m_280092_(GuiGraphics gui, Slot slot) {
        if (slot instanceof ITexturedSlot) {
            ITexturedSlot base = (ITexturedSlot)slot;
            int x = slot.f_40220_;
            int y = slot.f_40221_;
            base.getBackground2().draw(gui, x, y);
            if (!slot.m_6657_()) {
                RenderSystem.enableBlend();
                RenderSystem.enableBlend();
                base.getOverlay().draw(gui, x, y);
                RenderSystem.disableBlend();
            }
        }
        super.m_280092_(gui, slot);
    }

    public void bindTexture(ResourceLocation guiTexture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)guiTexture);
    }

    public boolean isMouseOver(double mouseX, double mouseY, int w, int h) {
        return mouseX >= (double)this.f_97735_ && mouseY >= (double)this.f_97736_ && mouseX < (double)(this.f_97735_ + w) && mouseY < (double)(this.f_97736_ + h);
    }

    public List<Rect2i> getExtraAreas() {
        return new ArrayList<Rect2i>();
    }

    protected Rect2i toRectangle2d(int x, int y, Texture texture) {
        return new Rect2i(x, y, texture.getWidth(), texture.getHeight());
    }
}

