/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.Powah;
import owmii.powah.api.energy.IEnergyConnector;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.inventory.CableContainer;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class CableBlock
extends AbstractEnergyBlock<CableConfig, CableBlock>
implements SimpleWaterloggedBlock,
IEnergyConnector {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    private static final VoxelShape CABLE = CableBlock.box(6.25, 6.25, 6.25, 9.75, 9.75, 9.75);
    private static final VoxelShape[] MULTIPART = new VoxelShape[]{CableBlock.box(6.5, 6.5, 0.0, 9.5, 9.5, 7.0), CableBlock.box(9.5, 6.5, 6.5, 16.0, 9.5, 9.5), CableBlock.box(6.5, 6.5, 9.5, 9.5, 9.5, 16.0), CableBlock.box(0.0, 6.5, 6.5, 6.5, 9.5, 9.5), CableBlock.box(6.5, 9.5, 6.5, 9.5, 16.0, 9.5), CableBlock.box(6.5, 0.0, 6.5, 9.5, 7.0, 9.5)};

    public CableBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public CableConfig getConfig() {
        return Powah.config().devices.cables;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return EnvHandler.INSTANCE.createCable(pos, state, (Tier)this.variant);
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = CABLE;
        if (blockGetter instanceof Level) {
            Level world = (Level)blockGetter;
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.NORTH)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[0]);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.EAST)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[1]);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.SOUTH)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[2]);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.WEST)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[3]);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue() || this.canConnectEnergy(world, pos, Direction.UP)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[4]);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() || this.canConnectEnergy(world, pos, Direction.DOWN)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[5]);
            }
        }
        return voxelShape;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        BlockState newState = this.createCableState(level, pos);
        if (newState != state) {
            level.m_7731_(pos, newState, 2);
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof CableTile) {
            CableTile cable = (CableTile)blockEntity;
            EnumSet<Direction> oldSides = EnumSet.copyOf(cable.energySides);
            cable.energySides.clear();
            for (Direction direction : Direction.values()) {
                if (!this.canConnectEnergy(level, pos, direction)) continue;
                cable.energySides.add(direction);
            }
            if (!oldSides.equals(cable.energySides)) {
                cable.sync();
            }
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.createCableState(context.m_43725_(), context.m_8083_());
    }

    private BlockState createCableState(Level world, BlockPos pos) {
        BlockState state = this.m_49966_();
        boolean[] north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean[] south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean[] west = this.canAttach(state, world, pos, Direction.WEST);
        boolean[] east = this.canAttach(state, world, pos, Direction.EAST);
        boolean[] up = this.canAttach(state, world, pos, Direction.UP);
        boolean[] down = this.canAttach(state, world, pos, Direction.DOWN);
        FluidState fluidState = world.m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north[0] && !north[1]))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south[0] && !south[1]))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west[0] && !west[1]))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east[0] && !east[1]))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up[0] && !up[1]))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down[0] && !down[1]))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Optional<Direction> hitSide = CableBlock.getHitSide(result.m_82450_(), pos);
        if (hitSide.isPresent() && !this.canConnectEnergy(world, pos, hitSide.get())) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Override
    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof CableTile) {
            return new CableContainer(id, inventory, (CableTile)te);
        }
        return super.getContainer(id, inventory, te, result);
    }

    @Override
    protected void additionalGuiData(FriendlyByteBuf buffer, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        CableBlock.getHitSide(result.m_82450_(), pos).ifPresent(side -> buffer.writeInt(side.m_122411_()));
        super.additionalGuiData(buffer, state, world, pos, player, hand, result);
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            cable.energySides.clear();
            for (Direction direction : Direction.values()) {
                if (!this.canConnectEnergy(world, pos, direction)) continue;
                cable.energySides.add(direction);
            }
            cable.sync();
        }
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public boolean[] canAttach(BlockState state, Level world, BlockPos pos, Direction direction) {
        return new boolean[]{world.m_8055_(pos.m_121945_(direction)).m_60734_() == this || this.canConnectEnergy(world, pos, direction), this.canConnectEnergy(world, pos, direction)};
    }

    public boolean canConnectEnergy(Level world, BlockPos pos, Direction direction) {
        BlockEntity tile = world.m_7702_(pos.m_121945_(direction));
        return !(tile instanceof CableTile) && EnvHandler.INSTANCE.hasEnergy(world, pos.m_121945_(direction), direction.m_122424_());
    }

    public static Optional<Direction> getHitSide(Vec3 hit, BlockPos pos) {
        double x = hit.f_82479_ - (double)pos.m_123341_();
        double y = hit.f_82480_ - (double)pos.m_123342_();
        double z = hit.f_82481_ - (double)pos.m_123343_();
        if (x > 0.0 && x < 0.4) {
            return Optional.of(Direction.WEST);
        }
        if (x > 0.6 && x < 1.0) {
            return Optional.of(Direction.EAST);
        }
        if (z > 0.0 && z < 0.4) {
            return Optional.of(Direction.NORTH);
        }
        if (z > 0.6 && z < 1.0) {
            return Optional.of(Direction.SOUTH);
        }
        if (y > 0.6 && y < 1.0) {
            return Optional.of(Direction.UP);
        }
        if (y > 0.0 && y < 0.4) {
            return Optional.of(Direction.DOWN);
        }
        return Optional.empty();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
        super.m_7926_(builder);
    }
}

